<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_AlarmRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_AlarmRequest
 * @subpackage Structs
 */
class XML_AlarmRequest extends Pagination
{
    /**
     * The AlarmSearchMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlarmSearchMethod;
    /**
     * The SearchAlarmDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchAlarmDateTime;
    /**
     * The SearchAlarmDeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchAlarmDeviceType;
    /**
     * The SearchAlarmStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchAlarmStatus;
    /**
     * The SearchAlarmText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchAlarmText;
    /**
     * Constructor method for XML_AlarmRequest
     * @uses XML_AlarmRequest::setAlarmSearchMethod()
     * @uses XML_AlarmRequest::setSearchAlarmDateTime()
     * @uses XML_AlarmRequest::setSearchAlarmDeviceType()
     * @uses XML_AlarmRequest::setSearchAlarmStatus()
     * @uses XML_AlarmRequest::setSearchAlarmText()
     * @param string $alarmSearchMethod
     * @param string $searchAlarmDateTime
     * @param string $searchAlarmDeviceType
     * @param string $searchAlarmStatus
     * @param string $searchAlarmText
     */
    public function __construct($alarmSearchMethod = null, $searchAlarmDateTime = null, $searchAlarmDeviceType = null, $searchAlarmStatus = null, $searchAlarmText = null)
    {
        $this
            ->setAlarmSearchMethod($alarmSearchMethod)
            ->setSearchAlarmDateTime($searchAlarmDateTime)
            ->setSearchAlarmDeviceType($searchAlarmDeviceType)
            ->setSearchAlarmStatus($searchAlarmStatus)
            ->setSearchAlarmText($searchAlarmText);
    }
    /**
     * Get AlarmSearchMethod value
     * @return string|null
     */
    public function getAlarmSearchMethod()
    {
        return $this->AlarmSearchMethod;
    }
    /**
     * Set AlarmSearchMethod value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmSearchMethod::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmSearchMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmSearchMethod
     * @return \App\Symmetry\Entities\StructType\XML_AlarmRequest
     */
    public function setAlarmSearchMethod($alarmSearchMethod = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmSearchMethod::valueIsValid($alarmSearchMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmSearchMethod', is_array($alarmSearchMethod) ? implode(', ', $alarmSearchMethod) : var_export($alarmSearchMethod, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmSearchMethod::getValidValues())), __LINE__);
        }
        $this->AlarmSearchMethod = $alarmSearchMethod;
        return $this;
    }
    /**
     * Get SearchAlarmDateTime value
     * @return string|null
     */
    public function getSearchAlarmDateTime()
    {
        return $this->SearchAlarmDateTime;
    }
    /**
     * Set SearchAlarmDateTime value
     * @param string $searchAlarmDateTime
     * @return \App\Symmetry\Entities\StructType\XML_AlarmRequest
     */
    public function setSearchAlarmDateTime($searchAlarmDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($searchAlarmDateTime) && !is_string($searchAlarmDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchAlarmDateTime, true), gettype($searchAlarmDateTime)), __LINE__);
        }
        $this->SearchAlarmDateTime = $searchAlarmDateTime;
        return $this;
    }
    /**
     * Get SearchAlarmDeviceType value
     * @return string|null
     */
    public function getSearchAlarmDeviceType()
    {
        return $this->SearchAlarmDeviceType;
    }
    /**
     * Set SearchAlarmDeviceType value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchAlarmDeviceType
     * @return \App\Symmetry\Entities\StructType\XML_AlarmRequest
     */
    public function setSearchAlarmDeviceType($searchAlarmDeviceType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($searchAlarmDeviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($searchAlarmDeviceType) ? implode(', ', $searchAlarmDeviceType) : var_export($searchAlarmDeviceType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->SearchAlarmDeviceType = $searchAlarmDeviceType;
        return $this;
    }
    /**
     * Get SearchAlarmStatus value
     * @return string|null
     */
    public function getSearchAlarmStatus()
    {
        return $this->SearchAlarmStatus;
    }
    /**
     * Set SearchAlarmStatus value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmStatus::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchAlarmStatus
     * @return \App\Symmetry\Entities\StructType\XML_AlarmRequest
     */
    public function setSearchAlarmStatus($searchAlarmStatus = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmStatus::valueIsValid($searchAlarmStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmStatus', is_array($searchAlarmStatus) ? implode(', ', $searchAlarmStatus) : var_export($searchAlarmStatus, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmStatus::getValidValues())), __LINE__);
        }
        $this->SearchAlarmStatus = $searchAlarmStatus;
        return $this;
    }
    /**
     * Get SearchAlarmText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchAlarmText()
    {
        return isset($this->SearchAlarmText) ? $this->SearchAlarmText : null;
    }
    /**
     * Set SearchAlarmText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchAlarmText
     * @return \App\Symmetry\Entities\StructType\XML_AlarmRequest
     */
    public function setSearchAlarmText($searchAlarmText = null)
    {
        // validation for constraint: string
        if (!is_null($searchAlarmText) && !is_string($searchAlarmText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchAlarmText, true), gettype($searchAlarmText)), __LINE__);
        }
        if (is_null($searchAlarmText) || (is_array($searchAlarmText) && empty($searchAlarmText))) {
            unset($this->SearchAlarmText);
        } else {
            $this->SearchAlarmText = $searchAlarmText;
        }
        return $this;
    }
}
