<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for G4TGetActivityDocument StructType
 * @subpackage Structs
 */
class G4TGetActivityDocument extends AbstractStructBase
{
    /**
     * The ActivityRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public $ActivityRequest;
    /**
     * Constructor method for G4TGetActivityDocument
     * @uses G4TGetActivityDocument::setActivityRequest()
     * @param \App\Symmetry\Entities\StructType\XML_ActivityRequest $activityRequest
     */
    public function __construct(\App\Symmetry\Entities\StructType\XML_ActivityRequest $activityRequest = null)
    {
        $this
            ->setActivityRequest($activityRequest);
    }
    /**
     * Get ActivityRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest|null
     */
    public function getActivityRequest()
    {
        return isset($this->ActivityRequest) ? $this->ActivityRequest : null;
    }
    /**
     * Set ActivityRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\StructType\XML_ActivityRequest $activityRequest
     * @return \App\Symmetry\Entities\StructType\G4TGetActivityDocument
     */
    public function setActivityRequest(\App\Symmetry\Entities\StructType\XML_ActivityRequest $activityRequest = null)
    {
        if (is_null($activityRequest) || (is_array($activityRequest) && empty($activityRequest))) {
            unset($this->ActivityRequest);
        } else {
            $this->ActivityRequest = $activityRequest;
        }
        return $this;
    }
}
