<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTV ServiceType
 * @subpackage Services
 */
class GTV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TVerifyLicense
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TVerifyLicense $parameters
     * @return \App\Symmetry\Entities\StructType\G4TVerifyLicenseResponse|bool
     */
    public function G4TVerifyLicense(\App\Symmetry\Entities\StructType\G4TVerifyLicense $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TVerifyLicense($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TVerifyLicenseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
