<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTI ServiceType
 * @subpackage Services
 */
class GTI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TImportCardHolderData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TImportCardHolderData $parameters
     * @return \App\Symmetry\Entities\StructType\G4TImportCardHolderDataResponse|bool
     */
    public function G4TImportCardHolderData(\App\Symmetry\Entities\StructType\G4TImportCardHolderData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TImportCardHolderData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TImportCardHolderDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
