<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTE ServiceType
 * @subpackage Services
 */
class GTE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TEditReaderGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TEditReaderGroup $parameters
     * @return \App\Symmetry\Entities\StructType\G4TEditReaderGroupResponse|bool
     */
    public function G4TEditReaderGroup(\App\Symmetry\Entities\StructType\G4TEditReaderGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TEditReaderGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TEditFloorGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TEditFloorGroup $parameters
     * @return \App\Symmetry\Entities\StructType\G4TEditFloorGroupResponse|bool
     */
    public function G4TEditFloorGroup(\App\Symmetry\Entities\StructType\G4TEditFloorGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TEditFloorGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TEditAccessCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TEditAccessCode $parameters
     * @return \App\Symmetry\Entities\StructType\G4TEditAccessCodeResponse|bool
     */
    public function G4TEditAccessCode(\App\Symmetry\Entities\StructType\G4TEditAccessCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TEditAccessCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TEditAccessCodeResponse|\App\Symmetry\Entities\StructType\G4TEditFloorGroupResponse|\App\Symmetry\Entities\StructType\G4TEditReaderGroupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
