<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTA ServiceType
 * @subpackage Services
 */
class GTA extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TAddAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TAddAlarms $parameters
     * @return \App\Symmetry\Entities\StructType\G4TAddAlarmsResponse|bool
     */
    public function G4TAddAlarms(\App\Symmetry\Entities\StructType\G4TAddAlarms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TAddAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TAddAlarmsWithCommandLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TAddAlarmsWithCommandLine $parameters
     * @return \App\Symmetry\Entities\StructType\G4TAddAlarmsWithCommandLineResponse|bool
     */
    public function G4TAddAlarmsWithCommandLine(\App\Symmetry\Entities\StructType\G4TAddAlarmsWithCommandLine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TAddAlarmsWithCommandLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TAddExtendedAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TAddExtendedAlarms $parameters
     * @return \App\Symmetry\Entities\StructType\G4TAddExtendedAlarmsResponse|bool
     */
    public function G4TAddExtendedAlarms(\App\Symmetry\Entities\StructType\G4TAddExtendedAlarms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TAddExtendedAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TAddAlarmsResponse|\App\Symmetry\Entities\StructType\G4TAddAlarmsWithCommandLineResponse|\App\Symmetry\Entities\StructType\G4TAddExtendedAlarmsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
