<?php

namespace App\Symmetry\Entities\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for enImportRecordResult EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:enImportRecordResult
 * @subpackage Enumerations
 */
class EnImportRecordResult extends AbstractStructEnumBase
{
    /**
     * Constant for value 'ImportRecord'
     * @return string 'ImportRecord'
     */
    const VALUE_IMPORT_RECORD = 'ImportRecord';
    /**
     * Constant for value 'ImportSuccessful'
     * @return string 'ImportSuccessful'
     */
    const VALUE_IMPORT_SUCCESSFUL = 'ImportSuccessful';
    /**
     * Constant for value 'MandatoryFieldsMissing'
     * @return string 'MandatoryFieldsMissing'
     */
    const VALUE_MANDATORY_FIELDS_MISSING = 'MandatoryFieldsMissing';
    /**
     * Constant for value 'CardIssueLevelsNotSet'
     * @return string 'CardIssueLevelsNotSet'
     */
    const VALUE_CARD_ISSUE_LEVELS_NOT_SET = 'CardIssueLevelsNotSet';
    /**
     * Constant for value 'ImportRecordNotFound'
     * @return string 'ImportRecordNotFound'
     */
    const VALUE_IMPORT_RECORD_NOT_FOUND = 'ImportRecordNotFound';
    /**
     * Constant for value 'ImportFormatError'
     * @return string 'ImportFormatError'
     */
    const VALUE_IMPORT_FORMAT_ERROR = 'ImportFormatError';
    /**
     * Constant for value 'ImportEncryptionError'
     * @return string 'ImportEncryptionError'
     */
    const VALUE_IMPORT_ENCRYPTION_ERROR = 'ImportEncryptionError';
    /**
     * Constant for value 'ImportGeneralError'
     * @return string 'ImportGeneralError'
     */
    const VALUE_IMPORT_GENERAL_ERROR = 'ImportGeneralError';
    /**
     * Constant for value 'CardAlreadyExists'
     * @return string 'CardAlreadyExists'
     */
    const VALUE_CARD_ALREADY_EXISTS = 'CardAlreadyExists';
    /**
     * Constant for value 'CardIssueLevelOutOfRange'
     * @return string 'CardIssueLevelOutOfRange'
     */
    const VALUE_CARD_ISSUE_LEVEL_OUT_OF_RANGE = 'CardIssueLevelOutOfRange';
    /**
     * Constant for value 'InvalidPINCode'
     * @return string 'InvalidPINCode'
     */
    const VALUE_INVALID_PINCODE = 'InvalidPINCode';
    /**
     * Constant for value 'InvalidCompanyID'
     * @return string 'InvalidCompanyID'
     */
    const VALUE_INVALID_COMPANY_ID = 'InvalidCompanyID';
    /**
     * Constant for value 'InvalidReaderGroupID'
     * @return string 'InvalidReaderGroupID'
     */
    const VALUE_INVALID_READER_GROUP_ID = 'InvalidReaderGroupID';
    /**
     * Constant for value 'InvalidTimeCodeID'
     * @return string 'InvalidTimeCodeID'
     */
    const VALUE_INVALID_TIME_CODE_ID = 'InvalidTimeCodeID';
    /**
     * Constant for value 'InvalidActiveDateRange'
     * @return string 'InvalidActiveDateRange'
     */
    const VALUE_INVALID_ACTIVE_DATE_RANGE = 'InvalidActiveDateRange';
    /**
     * Constant for value 'UnknownRecordRequest'
     * @return string 'UnknownRecordRequest'
     */
    const VALUE_UNKNOWN_RECORD_REQUEST = 'UnknownRecordRequest';
    /**
     * Constant for value 'FaceFileNotFound'
     * @return string 'FaceFileNotFound'
     */
    const VALUE_FACE_FILE_NOT_FOUND = 'FaceFileNotFound';
    /**
     * Constant for value 'SignatureFileNotFound'
     * @return string 'SignatureFileNotFound'
     */
    const VALUE_SIGNATURE_FILE_NOT_FOUND = 'SignatureFileNotFound';
    /**
     * Constant for value 'InvalidCustomerCode'
     * @return string 'InvalidCustomerCode'
     */
    const VALUE_INVALID_CUSTOMER_CODE = 'InvalidCustomerCode';
    /**
     * Constant for value 'MoreThanOneCustomerCode'
     * @return string 'MoreThanOneCustomerCode'
     */
    const VALUE_MORE_THAN_ONE_CUSTOMER_CODE = 'MoreThanOneCustomerCode';
    /**
     * Constant for value 'MoreThanOneCompany'
     * @return string 'MoreThanOneCompany'
     */
    const VALUE_MORE_THAN_ONE_COMPANY = 'MoreThanOneCompany';
    /**
     * Constant for value 'CardNumberOutOfRange'
     * @return string 'CardNumberOutOfRange'
     */
    const VALUE_CARD_NUMBER_OUT_OF_RANGE = 'CardNumberOutOfRange';
    /**
     * Constant for value 'CredentialNumberOutOfRange'
     * @return string 'CredentialNumberOutOfRange'
     */
    const VALUE_CREDENTIAL_NUMBER_OUT_OF_RANGE = 'CredentialNumberOutOfRange';
    /**
     * Constant for value 'InvalidSystemCode'
     * @return string 'InvalidSystemCode'
     */
    const VALUE_INVALID_SYSTEM_CODE = 'InvalidSystemCode';
    /**
     * Constant for value 'InvalidBadgeFormatID'
     * @return string 'InvalidBadgeFormatID'
     */
    const VALUE_INVALID_BADGE_FORMAT_ID = 'InvalidBadgeFormatID';
    /**
     * Constant for value 'MissingCardNumber'
     * @return string 'MissingCardNumber'
     */
    const VALUE_MISSING_CARD_NUMBER = 'MissingCardNumber';
    /**
     * Constant for value 'EmployeeReferenceNotUnique'
     * @return string 'EmployeeReferenceNotUnique'
     */
    const VALUE_EMPLOYEE_REFERENCE_NOT_UNIQUE = 'EmployeeReferenceNotUnique';
    /**
     * Constant for value 'ReaderGroupTimeCodeConflict'
     * @return string 'ReaderGroupTimeCodeConflict'
     */
    const VALUE_READER_GROUP_TIME_CODE_CONFLICT = 'ReaderGroupTimeCodeConflict';
    /**
     * Constant for value 'ReaderGroupTimeCodeAllreadyExistsForCardID'
     * @return string 'ReaderGroupTimeCodeAllreadyExistsForCardID'
     */
    const VALUE_READER_GROUP_TIME_CODE_ALLREADY_EXISTS_FOR_CARD_ID = 'ReaderGroupTimeCodeAllreadyExistsForCardID';
    /**
     * Constant for value 'BiometricImportError'
     * @return string 'BiometricImportError'
     */
    const VALUE_BIOMETRIC_IMPORT_ERROR = 'BiometricImportError';
    /**
     * Constant for value 'MandatoryPersonalDataError'
     * @return string 'MandatoryPersonalDataError'
     */
    const VALUE_MANDATORY_PERSONAL_DATA_ERROR = 'MandatoryPersonalDataError';
    /**
     * Constant for value 'InvalidReaderID'
     * @return string 'InvalidReaderID'
     */
    const VALUE_INVALID_READER_ID = 'InvalidReaderID';
    /**
     * Constant for value 'InvalidAccessGroupID'
     * @return string 'InvalidAccessGroupID'
     */
    const VALUE_INVALID_ACCESS_GROUP_ID = 'InvalidAccessGroupID';
    /**
     * Constant for value 'ReaderTimeCodeConflict'
     * @return string 'ReaderTimeCodeConflict'
     */
    const VALUE_READER_TIME_CODE_CONFLICT = 'ReaderTimeCodeConflict';
    /**
     * Constant for value 'ReaderTimeCodeAllreadyExistsForCardID'
     * @return string 'ReaderTimeCodeAllreadyExistsForCardID'
     */
    const VALUE_READER_TIME_CODE_ALLREADY_EXISTS_FOR_CARD_ID = 'ReaderTimeCodeAllreadyExistsForCardID';
    /**
     * Constant for value 'AccessGroupConflict'
     * @return string 'AccessGroupConflict'
     */
    const VALUE_ACCESS_GROUP_CONFLICT = 'AccessGroupConflict';
    /**
     * Constant for value 'AccessGroupAllreadyExistsForCardID'
     * @return string 'AccessGroupAllreadyExistsForCardID'
     */
    const VALUE_ACCESS_GROUP_ALLREADY_EXISTS_FOR_CARD_ID = 'AccessGroupAllreadyExistsForCardID';
    /**
     * Constant for value 'GSCFieldOutOfRange'
     * @return string 'GSCFieldOutOfRange'
     */
    const VALUE_GSCFIELD_OUT_OF_RANGE = 'GSCFieldOutOfRange';
    /**
     * Constant for value 'CardInUseByAConditionalCommand'
     * @return string 'CardInUseByAConditionalCommand'
     */
    const VALUE_CARD_IN_USE_BY_ACONDITIONAL_COMMAND = 'CardInUseByAConditionalCommand';
    /**
     * Constant for value 'NoVisitorEscortAssigned'
     * @return string 'NoVisitorEscortAssigned'
     */
    const VALUE_NO_VISITOR_ESCORT_ASSIGNED = 'NoVisitorEscortAssigned';
    /**
     * Constant for value 'IPMODataInvalid'
     * @return string 'IPMODataInvalid'
     */
    const VALUE_IPMODATA_INVALID = 'IPMODataInvalid';
    /**
     * Constant for value 'ActiveOrInactiveDateOutOfRange'
     * @return string 'ActiveOrInactiveDateOutOfRange'
     */
    const VALUE_ACTIVE_OR_INACTIVE_DATE_OUT_OF_RANGE = 'ActiveOrInactiveDateOutOfRange';
    /**
     * Constant for value 'InvalidCardUsageRemaining'
     * @return string 'InvalidCardUsageRemaining'
     */
    const VALUE_INVALID_CARD_USAGE_REMAINING = 'InvalidCardUsageRemaining';
    /**
     * Constant for value 'InvalidIDSCode'
     * @return string 'InvalidIDSCode'
     */
    const VALUE_INVALID_IDSCODE = 'InvalidIDSCode';
    /**
     * Constant for value 'InvalidAreaID'
     * @return string 'InvalidAreaID'
     */
    const VALUE_INVALID_AREA_ID = 'InvalidAreaID';
    /**
     * Constant for value 'AreaConflict'
     * @return string 'AreaConflict'
     */
    const VALUE_AREA_CONFLICT = 'AreaConflict';
    /**
     * Constant for value 'AreaAlreadyExistsForCardID'
     * @return string 'AreaAlreadyExistsForCardID'
     */
    const VALUE_AREA_ALREADY_EXISTS_FOR_CARD_ID = 'AreaAlreadyExistsForCardID';
    /**
     * Constant for value 'FailedToIdentifyUniqueCardholder'
     * @return string 'FailedToIdentifyUniqueCardholder'
     */
    const VALUE_FAILED_TO_IDENTIFY_UNIQUE_CARDHOLDER = 'FailedToIdentifyUniqueCardholder';
    /**
     * Constant for value 'MultipleCardsPerCardholderNotEnabled'
     * @return string 'MultipleCardsPerCardholderNotEnabled'
     */
    const VALUE_MULTIPLE_CARDS_PER_CARDHOLDER_NOT_ENABLED = 'MultipleCardsPerCardholderNotEnabled';
    /**
     * Constant for value 'KeycardHolderAndExecutiveCardOptionsMutuallyExclusive'
     * @return string 'KeycardHolderAndExecutiveCardOptionsMutuallyExclusive'
     */
    const VALUE_KEYCARD_HOLDER_AND_EXECUTIVE_CARD_OPTIONS_MUTUALLY_EXCLUSIVE = 'KeycardHolderAndExecutiveCardOptionsMutuallyExclusive';
    /**
     * Constant for value 'IDSCodeNotUnique'
     * @return string 'IDSCodeNotUnique'
     */
    const VALUE_IDSCODE_NOT_UNIQUE = 'IDSCodeNotUnique';
    /**
     * Return allowed values
     * @uses self::VALUE_IMPORT_RECORD
     * @uses self::VALUE_IMPORT_SUCCESSFUL
     * @uses self::VALUE_MANDATORY_FIELDS_MISSING
     * @uses self::VALUE_CARD_ISSUE_LEVELS_NOT_SET
     * @uses self::VALUE_IMPORT_RECORD_NOT_FOUND
     * @uses self::VALUE_IMPORT_FORMAT_ERROR
     * @uses self::VALUE_IMPORT_ENCRYPTION_ERROR
     * @uses self::VALUE_IMPORT_GENERAL_ERROR
     * @uses self::VALUE_CARD_ALREADY_EXISTS
     * @uses self::VALUE_CARD_ISSUE_LEVEL_OUT_OF_RANGE
     * @uses self::VALUE_INVALID_PINCODE
     * @uses self::VALUE_INVALID_COMPANY_ID
     * @uses self::VALUE_INVALID_READER_GROUP_ID
     * @uses self::VALUE_INVALID_TIME_CODE_ID
     * @uses self::VALUE_INVALID_ACTIVE_DATE_RANGE
     * @uses self::VALUE_UNKNOWN_RECORD_REQUEST
     * @uses self::VALUE_FACE_FILE_NOT_FOUND
     * @uses self::VALUE_SIGNATURE_FILE_NOT_FOUND
     * @uses self::VALUE_INVALID_CUSTOMER_CODE
     * @uses self::VALUE_MORE_THAN_ONE_CUSTOMER_CODE
     * @uses self::VALUE_MORE_THAN_ONE_COMPANY
     * @uses self::VALUE_CARD_NUMBER_OUT_OF_RANGE
     * @uses self::VALUE_CREDENTIAL_NUMBER_OUT_OF_RANGE
     * @uses self::VALUE_INVALID_SYSTEM_CODE
     * @uses self::VALUE_INVALID_BADGE_FORMAT_ID
     * @uses self::VALUE_MISSING_CARD_NUMBER
     * @uses self::VALUE_EMPLOYEE_REFERENCE_NOT_UNIQUE
     * @uses self::VALUE_READER_GROUP_TIME_CODE_CONFLICT
     * @uses self::VALUE_READER_GROUP_TIME_CODE_ALLREADY_EXISTS_FOR_CARD_ID
     * @uses self::VALUE_BIOMETRIC_IMPORT_ERROR
     * @uses self::VALUE_MANDATORY_PERSONAL_DATA_ERROR
     * @uses self::VALUE_INVALID_READER_ID
     * @uses self::VALUE_INVALID_ACCESS_GROUP_ID
     * @uses self::VALUE_READER_TIME_CODE_CONFLICT
     * @uses self::VALUE_READER_TIME_CODE_ALLREADY_EXISTS_FOR_CARD_ID
     * @uses self::VALUE_ACCESS_GROUP_CONFLICT
     * @uses self::VALUE_ACCESS_GROUP_ALLREADY_EXISTS_FOR_CARD_ID
     * @uses self::VALUE_GSCFIELD_OUT_OF_RANGE
     * @uses self::VALUE_CARD_IN_USE_BY_ACONDITIONAL_COMMAND
     * @uses self::VALUE_NO_VISITOR_ESCORT_ASSIGNED
     * @uses self::VALUE_IPMODATA_INVALID
     * @uses self::VALUE_ACTIVE_OR_INACTIVE_DATE_OUT_OF_RANGE
     * @uses self::VALUE_INVALID_CARD_USAGE_REMAINING
     * @uses self::VALUE_INVALID_IDSCODE
     * @uses self::VALUE_INVALID_AREA_ID
     * @uses self::VALUE_AREA_CONFLICT
     * @uses self::VALUE_AREA_ALREADY_EXISTS_FOR_CARD_ID
     * @uses self::VALUE_FAILED_TO_IDENTIFY_UNIQUE_CARDHOLDER
     * @uses self::VALUE_MULTIPLE_CARDS_PER_CARDHOLDER_NOT_ENABLED
     * @uses self::VALUE_KEYCARD_HOLDER_AND_EXECUTIVE_CARD_OPTIONS_MUTUALLY_EXCLUSIVE
     * @uses self::VALUE_IDSCODE_NOT_UNIQUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMPORT_RECORD,
            self::VALUE_IMPORT_SUCCESSFUL,
            self::VALUE_MANDATORY_FIELDS_MISSING,
            self::VALUE_CARD_ISSUE_LEVELS_NOT_SET,
            self::VALUE_IMPORT_RECORD_NOT_FOUND,
            self::VALUE_IMPORT_FORMAT_ERROR,
            self::VALUE_IMPORT_ENCRYPTION_ERROR,
            self::VALUE_IMPORT_GENERAL_ERROR,
            self::VALUE_CARD_ALREADY_EXISTS,
            self::VALUE_CARD_ISSUE_LEVEL_OUT_OF_RANGE,
            self::VALUE_INVALID_PINCODE,
            self::VALUE_INVALID_COMPANY_ID,
            self::VALUE_INVALID_READER_GROUP_ID,
            self::VALUE_INVALID_TIME_CODE_ID,
            self::VALUE_INVALID_ACTIVE_DATE_RANGE,
            self::VALUE_UNKNOWN_RECORD_REQUEST,
            self::VALUE_FACE_FILE_NOT_FOUND,
            self::VALUE_SIGNATURE_FILE_NOT_FOUND,
            self::VALUE_INVALID_CUSTOMER_CODE,
            self::VALUE_MORE_THAN_ONE_CUSTOMER_CODE,
            self::VALUE_MORE_THAN_ONE_COMPANY,
            self::VALUE_CARD_NUMBER_OUT_OF_RANGE,
            self::VALUE_CREDENTIAL_NUMBER_OUT_OF_RANGE,
            self::VALUE_INVALID_SYSTEM_CODE,
            self::VALUE_INVALID_BADGE_FORMAT_ID,
            self::VALUE_MISSING_CARD_NUMBER,
            self::VALUE_EMPLOYEE_REFERENCE_NOT_UNIQUE,
            self::VALUE_READER_GROUP_TIME_CODE_CONFLICT,
            self::VALUE_READER_GROUP_TIME_CODE_ALLREADY_EXISTS_FOR_CARD_ID,
            self::VALUE_BIOMETRIC_IMPORT_ERROR,
            self::VALUE_MANDATORY_PERSONAL_DATA_ERROR,
            self::VALUE_INVALID_READER_ID,
            self::VALUE_INVALID_ACCESS_GROUP_ID,
            self::VALUE_READER_TIME_CODE_CONFLICT,
            self::VALUE_READER_TIME_CODE_ALLREADY_EXISTS_FOR_CARD_ID,
            self::VALUE_ACCESS_GROUP_CONFLICT,
            self::VALUE_ACCESS_GROUP_ALLREADY_EXISTS_FOR_CARD_ID,
            self::VALUE_GSCFIELD_OUT_OF_RANGE,
            self::VALUE_CARD_IN_USE_BY_ACONDITIONAL_COMMAND,
            self::VALUE_NO_VISITOR_ESCORT_ASSIGNED,
            self::VALUE_IPMODATA_INVALID,
            self::VALUE_ACTIVE_OR_INACTIVE_DATE_OUT_OF_RANGE,
            self::VALUE_INVALID_CARD_USAGE_REMAINING,
            self::VALUE_INVALID_IDSCODE,
            self::VALUE_INVALID_AREA_ID,
            self::VALUE_AREA_CONFLICT,
            self::VALUE_AREA_ALREADY_EXISTS_FOR_CARD_ID,
            self::VALUE_FAILED_TO_IDENTIFY_UNIQUE_CARDHOLDER,
            self::VALUE_MULTIPLE_CARDS_PER_CARDHOLDER_NOT_ENABLED,
            self::VALUE_KEYCARD_HOLDER_AND_EXECUTIVE_CARD_OPTIONS_MUTUALLY_EXCLUSIVE,
            self::VALUE_IDSCODE_NOT_UNIQUE,
        );
    }
}
