<?php

namespace App\Symmetry\Entities\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for enCardFormat EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:enCardFormat
 * @subpackage Enumerations
 */
class EnCardFormat extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'PIV_FASC_N'
     * @return string 'PIV_FASC_N'
     */
    const VALUE_PIV_FASC_N = 'PIV_FASC_N';
    /**
     * Constant for value 'SRSeries_15Digit'
     * @return string 'SRSeries_15Digit'
     */
    const VALUE_SRSERIES_15_DIGIT = 'SRSeries_15Digit';
    /**
     * Constant for value 'SRSeries_10And12Digit'
     * @return string 'SRSeries_10And12Digit'
     */
    const VALUE_SRSERIES_10_AND_12_DIGIT = 'SRSeries_10And12Digit';
    /**
     * Constant for value 'CMV_U'
     * @return string 'CMV_U'
     */
    const VALUE_CMV_U = 'CMV_U';
    /**
     * Constant for value 'CMV_F'
     * @return string 'CMV_F'
     */
    const VALUE_CMV_F = 'CMV_F';
    /**
     * Constant for value 'HID_SE_Card'
     * @return string 'HID_SE_Card'
     */
    const VALUE_HID_SE_CARD = 'HID_SE_Card';
    /**
     * Constant for value 'Corporate_1000_48'
     * @return string 'Corporate_1000_48'
     */
    const VALUE_CORPORATE_1000_48 = 'Corporate_1000_48';
    /**
     * Constant for value 'Barcode_37'
     * @return string 'Barcode_37'
     */
    const VALUE_BARCODE_37 = 'Barcode_37';
    /**
     * Constant for value 'NXP_Desfire_56'
     * @return string 'NXP_Desfire_56'
     */
    const VALUE_NXP_DESFIRE_56 = 'NXP_Desfire_56';
    /**
     * Constant for value 'SeiwgV1'
     * @return string 'SeiwgV1'
     */
    const VALUE_SEIWG_V_1 = 'SeiwgV1';
    /**
     * Constant for value 'SeiwgGSC2_1'
     * @return string 'SeiwgGSC2_1'
     */
    const VALUE_SEIWG_GSC_2_1 = 'SeiwgGSC2_1';
    /**
     * Constant for value 'Legacy'
     * @return string 'Legacy'
     */
    const VALUE_LEGACY = 'Legacy';
    /**
     * Constant for value 'PIV_UUID'
     * @return string 'PIV_UUID'
     */
    const VALUE_PIV_UUID = 'PIV_UUID';
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_PIV_FASC_N
     * @uses self::VALUE_SRSERIES_15_DIGIT
     * @uses self::VALUE_SRSERIES_10_AND_12_DIGIT
     * @uses self::VALUE_CMV_U
     * @uses self::VALUE_CMV_F
     * @uses self::VALUE_HID_SE_CARD
     * @uses self::VALUE_CORPORATE_1000_48
     * @uses self::VALUE_BARCODE_37
     * @uses self::VALUE_NXP_DESFIRE_56
     * @uses self::VALUE_SEIWG_V_1
     * @uses self::VALUE_SEIWG_GSC_2_1
     * @uses self::VALUE_LEGACY
     * @uses self::VALUE_PIV_UUID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_PIV_FASC_N,
            self::VALUE_SRSERIES_15_DIGIT,
            self::VALUE_SRSERIES_10_AND_12_DIGIT,
            self::VALUE_CMV_U,
            self::VALUE_CMV_F,
            self::VALUE_HID_SE_CARD,
            self::VALUE_CORPORATE_1000_48,
            self::VALUE_BARCODE_37,
            self::VALUE_NXP_DESFIRE_56,
            self::VALUE_SEIWG_V_1,
            self::VALUE_SEIWG_GSC_2_1,
            self::VALUE_LEGACY,
            self::VALUE_PIV_UUID,
        );
    }
}
