<?php

namespace App\Symmetry\Entities\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for enAlarmStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:enAlarmStatus
 * @subpackage Enumerations
 */
class EnAlarmStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotInAlarm'
     * @return string 'NotInAlarm'
     */
    const VALUE_NOT_IN_ALARM = 'NotInAlarm';
    /**
     * Constant for value 'InAlarm'
     * @return string 'InAlarm'
     */
    const VALUE_IN_ALARM = 'InAlarm';
    /**
     * Constant for value 'AcknowledgedButNotReset'
     * @return string 'AcknowledgedButNotReset'
     */
    const VALUE_ACKNOWLEDGED_BUT_NOT_RESET = 'AcknowledgedButNotReset';
    /**
     * Constant for value 'AcknowledgedAndReset'
     * @return string 'AcknowledgedAndReset'
     */
    const VALUE_ACKNOWLEDGED_AND_RESET = 'AcknowledgedAndReset';
    /**
     * Constant for value 'Ignore'
     * @return string 'Ignore'
     */
    const VALUE_IGNORE = 'Ignore';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_IN_ALARM
     * @uses self::VALUE_IN_ALARM
     * @uses self::VALUE_ACKNOWLEDGED_BUT_NOT_RESET
     * @uses self::VALUE_ACKNOWLEDGED_AND_RESET
     * @uses self::VALUE_IGNORE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_IN_ALARM,
            self::VALUE_IN_ALARM,
            self::VALUE_ACKNOWLEDGED_BUT_NOT_RESET,
            self::VALUE_ACKNOWLEDGED_AND_RESET,
            self::VALUE_IGNORE,
        );
    }
}
