<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_Version StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_Version
 * @subpackage Structs
 */
class XML_Version extends AbstractStructBase
{
    /**
     * The BuildLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildLevel;
    /**
     * The LanguageVariant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageVariant;
    /**
     * The MajorVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MajorVersion;
    /**
     * The MinorVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinorVersion;
    /**
     * The OS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OS;
    /**
     * The ReleaseVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReleaseVersion;
    /**
     * The What
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $What;
    /**
     * Constructor method for XML_Version
     * @uses XML_Version::setBuildLevel()
     * @uses XML_Version::setLanguageVariant()
     * @uses XML_Version::setMajorVersion()
     * @uses XML_Version::setMinorVersion()
     * @uses XML_Version::setOS()
     * @uses XML_Version::setReleaseVersion()
     * @uses XML_Version::setWhat()
     * @param string $buildLevel
     * @param string $languageVariant
     * @param string $majorVersion
     * @param string $minorVersion
     * @param string $oS
     * @param string $releaseVersion
     * @param string $what
     */
    public function __construct($buildLevel = null, $languageVariant = null, $majorVersion = null, $minorVersion = null, $oS = null, $releaseVersion = null, $what = null)
    {
        $this
            ->setBuildLevel($buildLevel)
            ->setLanguageVariant($languageVariant)
            ->setMajorVersion($majorVersion)
            ->setMinorVersion($minorVersion)
            ->setOS($oS)
            ->setReleaseVersion($releaseVersion)
            ->setWhat($what);
    }
    /**
     * Get BuildLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildLevel()
    {
        return isset($this->BuildLevel) ? $this->BuildLevel : null;
    }
    /**
     * Set BuildLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildLevel
     * @return \App\Symmetry\Entities\StructType\XML_Version
     */
    public function setBuildLevel($buildLevel = null)
    {
        // validation for constraint: string
        if (!is_null($buildLevel) && !is_string($buildLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildLevel, true), gettype($buildLevel)), __LINE__);
        }
        if (is_null($buildLevel) || (is_array($buildLevel) && empty($buildLevel))) {
            unset($this->BuildLevel);
        } else {
            $this->BuildLevel = $buildLevel;
        }
        return $this;
    }
    /**
     * Get LanguageVariant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageVariant()
    {
        return isset($this->LanguageVariant) ? $this->LanguageVariant : null;
    }
    /**
     * Set LanguageVariant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageVariant
     * @return \App\Symmetry\Entities\StructType\XML_Version
     */
    public function setLanguageVariant($languageVariant = null)
    {
        // validation for constraint: string
        if (!is_null($languageVariant) && !is_string($languageVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageVariant, true), gettype($languageVariant)), __LINE__);
        }
        if (is_null($languageVariant) || (is_array($languageVariant) && empty($languageVariant))) {
            unset($this->LanguageVariant);
        } else {
            $this->LanguageVariant = $languageVariant;
        }
        return $this;
    }
    /**
     * Get MajorVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMajorVersion()
    {
        return isset($this->MajorVersion) ? $this->MajorVersion : null;
    }
    /**
     * Set MajorVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $majorVersion
     * @return \App\Symmetry\Entities\StructType\XML_Version
     */
    public function setMajorVersion($majorVersion = null)
    {
        // validation for constraint: string
        if (!is_null($majorVersion) && !is_string($majorVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($majorVersion, true), gettype($majorVersion)), __LINE__);
        }
        if (is_null($majorVersion) || (is_array($majorVersion) && empty($majorVersion))) {
            unset($this->MajorVersion);
        } else {
            $this->MajorVersion = $majorVersion;
        }
        return $this;
    }
    /**
     * Get MinorVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinorVersion()
    {
        return isset($this->MinorVersion) ? $this->MinorVersion : null;
    }
    /**
     * Set MinorVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minorVersion
     * @return \App\Symmetry\Entities\StructType\XML_Version
     */
    public function setMinorVersion($minorVersion = null)
    {
        // validation for constraint: string
        if (!is_null($minorVersion) && !is_string($minorVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minorVersion, true), gettype($minorVersion)), __LINE__);
        }
        if (is_null($minorVersion) || (is_array($minorVersion) && empty($minorVersion))) {
            unset($this->MinorVersion);
        } else {
            $this->MinorVersion = $minorVersion;
        }
        return $this;
    }
    /**
     * Get OS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOS()
    {
        return isset($this->OS) ? $this->OS : null;
    }
    /**
     * Set OS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oS
     * @return \App\Symmetry\Entities\StructType\XML_Version
     */
    public function setOS($oS = null)
    {
        // validation for constraint: string
        if (!is_null($oS) && !is_string($oS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS, true), gettype($oS)), __LINE__);
        }
        if (is_null($oS) || (is_array($oS) && empty($oS))) {
            unset($this->OS);
        } else {
            $this->OS = $oS;
        }
        return $this;
    }
    /**
     * Get ReleaseVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReleaseVersion()
    {
        return isset($this->ReleaseVersion) ? $this->ReleaseVersion : null;
    }
    /**
     * Set ReleaseVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $releaseVersion
     * @return \App\Symmetry\Entities\StructType\XML_Version
     */
    public function setReleaseVersion($releaseVersion = null)
    {
        // validation for constraint: string
        if (!is_null($releaseVersion) && !is_string($releaseVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releaseVersion, true), gettype($releaseVersion)), __LINE__);
        }
        if (is_null($releaseVersion) || (is_array($releaseVersion) && empty($releaseVersion))) {
            unset($this->ReleaseVersion);
        } else {
            $this->ReleaseVersion = $releaseVersion;
        }
        return $this;
    }
    /**
     * Get What value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhat()
    {
        return isset($this->What) ? $this->What : null;
    }
    /**
     * Set What value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $what
     * @return \App\Symmetry\Entities\StructType\XML_Version
     */
    public function setWhat($what = null)
    {
        // validation for constraint: string
        if (!is_null($what) && !is_string($what)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($what, true), gettype($what)), __LINE__);
        }
        if (is_null($what) || (is_array($what) && empty($what))) {
            unset($this->What);
        } else {
            $this->What = $what;
        }
        return $this;
    }
}
