<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_VerifyLicense StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_VerifyLicense
 * @subpackage Structs
 */
class XML_VerifyLicense extends AbstractStructBase
{
    /**
     * The License
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $License;
    /**
     * Constructor method for XML_VerifyLicense
     * @uses XML_VerifyLicense::setLicense()
     * @param string $license
     */
    public function __construct($license = null)
    {
        $this
            ->setLicense($license);
    }
    /**
     * Get License value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLicense()
    {
        return isset($this->License) ? $this->License : null;
    }
    /**
     * Set License value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $license
     * @return \App\Symmetry\Entities\StructType\XML_VerifyLicense
     */
    public function setLicense($license = null)
    {
        // validation for constraint: string
        if (!is_null($license) && !is_string($license)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($license, true), gettype($license)), __LINE__);
        }
        if (is_null($license) || (is_array($license) && empty($license))) {
            unset($this->License);
        } else {
            $this->License = $license;
        }
        return $this;
    }
}
