<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_SystemParameters StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_SystemParameters
 * @subpackage Structs
 */
class XML_SystemParameters extends AbstractStructBase
{
    /**
     * The CurrentDateAndTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrentDateAndTime;
    /**
     * The DaylightSavingTimeZoneName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DaylightSavingTimeZoneName;
    /**
     * The IsDayLightSavingTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDayLightSavingTime;
    /**
     * The StandardTimeZoneName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StandardTimeZoneName;
    /**
     * The SystemEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SystemEndDate;
    /**
     * The SystemStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SystemStartDate;
    /**
     * The UTC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UTC;
    /**
     * The UTCTimeOffsetMins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $UTCTimeOffsetMins;
    /**
     * Constructor method for XML_SystemParameters
     * @uses XML_SystemParameters::setCurrentDateAndTime()
     * @uses XML_SystemParameters::setDaylightSavingTimeZoneName()
     * @uses XML_SystemParameters::setIsDayLightSavingTime()
     * @uses XML_SystemParameters::setStandardTimeZoneName()
     * @uses XML_SystemParameters::setSystemEndDate()
     * @uses XML_SystemParameters::setSystemStartDate()
     * @uses XML_SystemParameters::setUTC()
     * @uses XML_SystemParameters::setUTCTimeOffsetMins()
     * @param string $currentDateAndTime
     * @param string $daylightSavingTimeZoneName
     * @param bool $isDayLightSavingTime
     * @param string $standardTimeZoneName
     * @param string $systemEndDate
     * @param string $systemStartDate
     * @param string $uTC
     * @param float $uTCTimeOffsetMins
     */
    public function __construct($currentDateAndTime = null, $daylightSavingTimeZoneName = null, $isDayLightSavingTime = null, $standardTimeZoneName = null, $systemEndDate = null, $systemStartDate = null, $uTC = null, $uTCTimeOffsetMins = null)
    {
        $this
            ->setCurrentDateAndTime($currentDateAndTime)
            ->setDaylightSavingTimeZoneName($daylightSavingTimeZoneName)
            ->setIsDayLightSavingTime($isDayLightSavingTime)
            ->setStandardTimeZoneName($standardTimeZoneName)
            ->setSystemEndDate($systemEndDate)
            ->setSystemStartDate($systemStartDate)
            ->setUTC($uTC)
            ->setUTCTimeOffsetMins($uTCTimeOffsetMins);
    }
    /**
     * Get CurrentDateAndTime value
     * @return string|null
     */
    public function getCurrentDateAndTime()
    {
        return $this->CurrentDateAndTime;
    }
    /**
     * Set CurrentDateAndTime value
     * @param string $currentDateAndTime
     * @return \App\Symmetry\Entities\StructType\XML_SystemParameters
     */
    public function setCurrentDateAndTime($currentDateAndTime = null)
    {
        // validation for constraint: string
        if (!is_null($currentDateAndTime) && !is_string($currentDateAndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentDateAndTime, true), gettype($currentDateAndTime)), __LINE__);
        }
        $this->CurrentDateAndTime = $currentDateAndTime;
        return $this;
    }
    /**
     * Get DaylightSavingTimeZoneName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaylightSavingTimeZoneName()
    {
        return isset($this->DaylightSavingTimeZoneName) ? $this->DaylightSavingTimeZoneName : null;
    }
    /**
     * Set DaylightSavingTimeZoneName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daylightSavingTimeZoneName
     * @return \App\Symmetry\Entities\StructType\XML_SystemParameters
     */
    public function setDaylightSavingTimeZoneName($daylightSavingTimeZoneName = null)
    {
        // validation for constraint: string
        if (!is_null($daylightSavingTimeZoneName) && !is_string($daylightSavingTimeZoneName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daylightSavingTimeZoneName, true), gettype($daylightSavingTimeZoneName)), __LINE__);
        }
        if (is_null($daylightSavingTimeZoneName) || (is_array($daylightSavingTimeZoneName) && empty($daylightSavingTimeZoneName))) {
            unset($this->DaylightSavingTimeZoneName);
        } else {
            $this->DaylightSavingTimeZoneName = $daylightSavingTimeZoneName;
        }
        return $this;
    }
    /**
     * Get IsDayLightSavingTime value
     * @return bool|null
     */
    public function getIsDayLightSavingTime()
    {
        return $this->IsDayLightSavingTime;
    }
    /**
     * Set IsDayLightSavingTime value
     * @param bool $isDayLightSavingTime
     * @return \App\Symmetry\Entities\StructType\XML_SystemParameters
     */
    public function setIsDayLightSavingTime($isDayLightSavingTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDayLightSavingTime) && !is_bool($isDayLightSavingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDayLightSavingTime, true), gettype($isDayLightSavingTime)), __LINE__);
        }
        $this->IsDayLightSavingTime = $isDayLightSavingTime;
        return $this;
    }
    /**
     * Get StandardTimeZoneName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandardTimeZoneName()
    {
        return isset($this->StandardTimeZoneName) ? $this->StandardTimeZoneName : null;
    }
    /**
     * Set StandardTimeZoneName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standardTimeZoneName
     * @return \App\Symmetry\Entities\StructType\XML_SystemParameters
     */
    public function setStandardTimeZoneName($standardTimeZoneName = null)
    {
        // validation for constraint: string
        if (!is_null($standardTimeZoneName) && !is_string($standardTimeZoneName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standardTimeZoneName, true), gettype($standardTimeZoneName)), __LINE__);
        }
        if (is_null($standardTimeZoneName) || (is_array($standardTimeZoneName) && empty($standardTimeZoneName))) {
            unset($this->StandardTimeZoneName);
        } else {
            $this->StandardTimeZoneName = $standardTimeZoneName;
        }
        return $this;
    }
    /**
     * Get SystemEndDate value
     * @return string|null
     */
    public function getSystemEndDate()
    {
        return $this->SystemEndDate;
    }
    /**
     * Set SystemEndDate value
     * @param string $systemEndDate
     * @return \App\Symmetry\Entities\StructType\XML_SystemParameters
     */
    public function setSystemEndDate($systemEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemEndDate) && !is_string($systemEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemEndDate, true), gettype($systemEndDate)), __LINE__);
        }
        $this->SystemEndDate = $systemEndDate;
        return $this;
    }
    /**
     * Get SystemStartDate value
     * @return string|null
     */
    public function getSystemStartDate()
    {
        return $this->SystemStartDate;
    }
    /**
     * Set SystemStartDate value
     * @param string $systemStartDate
     * @return \App\Symmetry\Entities\StructType\XML_SystemParameters
     */
    public function setSystemStartDate($systemStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemStartDate) && !is_string($systemStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemStartDate, true), gettype($systemStartDate)), __LINE__);
        }
        $this->SystemStartDate = $systemStartDate;
        return $this;
    }
    /**
     * Get UTC value
     * @return string|null
     */
    public function getUTC()
    {
        return $this->UTC;
    }
    /**
     * Set UTC value
     * @param string $uTC
     * @return \App\Symmetry\Entities\StructType\XML_SystemParameters
     */
    public function setUTC($uTC = null)
    {
        // validation for constraint: string
        if (!is_null($uTC) && !is_string($uTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTC, true), gettype($uTC)), __LINE__);
        }
        $this->UTC = $uTC;
        return $this;
    }
    /**
     * Get UTCTimeOffsetMins value
     * @return float|null
     */
    public function getUTCTimeOffsetMins()
    {
        return $this->UTCTimeOffsetMins;
    }
    /**
     * Set UTCTimeOffsetMins value
     * @param float $uTCTimeOffsetMins
     * @return \App\Symmetry\Entities\StructType\XML_SystemParameters
     */
    public function setUTCTimeOffsetMins($uTCTimeOffsetMins = null)
    {
        // validation for constraint: float
        if (!is_null($uTCTimeOffsetMins) && !(is_float($uTCTimeOffsetMins) || is_numeric($uTCTimeOffsetMins))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uTCTimeOffsetMins, true), gettype($uTCTimeOffsetMins)), __LINE__);
        }
        $this->UTCTimeOffsetMins = $uTCTimeOffsetMins;
        return $this;
    }
}
