<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_SendDeviceCommandRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_SendDeviceCommandRequest
 * @subpackage Structs
 */
class XML_SendDeviceCommandRequest extends AbstractStructBase
{
    /**
     * The CommandCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommandCode;
    /**
     * The CommandType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommandType;
    /**
     * The DeviceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceID;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeviceType;
    /**
     * The TailInfoOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TailInfoOption;
    /**
     * The TailStructureNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TailStructureNumber;
    /**
     * The Value1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Value1;
    /**
     * The Value2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value2;
    /**
     * Constructor method for XML_SendDeviceCommandRequest
     * @uses XML_SendDeviceCommandRequest::setCommandCode()
     * @uses XML_SendDeviceCommandRequest::setCommandType()
     * @uses XML_SendDeviceCommandRequest::setDeviceID()
     * @uses XML_SendDeviceCommandRequest::setDeviceType()
     * @uses XML_SendDeviceCommandRequest::setTailInfoOption()
     * @uses XML_SendDeviceCommandRequest::setTailStructureNumber()
     * @uses XML_SendDeviceCommandRequest::setValue1()
     * @uses XML_SendDeviceCommandRequest::setValue2()
     * @param int $commandCode
     * @param string $commandType
     * @param int $deviceID
     * @param string $deviceType
     * @param string $tailInfoOption
     * @param int $tailStructureNumber
     * @param int $value1
     * @param string $value2
     */
    public function __construct($commandCode = null, $commandType = null, $deviceID = null, $deviceType = null, $tailInfoOption = null, $tailStructureNumber = null, $value1 = null, $value2 = null)
    {
        $this
            ->setCommandCode($commandCode)
            ->setCommandType($commandType)
            ->setDeviceID($deviceID)
            ->setDeviceType($deviceType)
            ->setTailInfoOption($tailInfoOption)
            ->setTailStructureNumber($tailStructureNumber)
            ->setValue1($value1)
            ->setValue2($value2);
    }
    /**
     * Get CommandCode value
     * @return int|null
     */
    public function getCommandCode()
    {
        return $this->CommandCode;
    }
    /**
     * Set CommandCode value
     * @param int $commandCode
     * @return \App\Symmetry\Entities\StructType\XML_SendDeviceCommandRequest
     */
    public function setCommandCode($commandCode = null)
    {
        // validation for constraint: int
        if (!is_null($commandCode) && !(is_int($commandCode) || ctype_digit($commandCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commandCode, true), gettype($commandCode)), __LINE__);
        }
        $this->CommandCode = $commandCode;
        return $this;
    }
    /**
     * Get CommandType value
     * @return string|null
     */
    public function getCommandType()
    {
        return $this->CommandType;
    }
    /**
     * Set CommandType value
     * @uses \App\Symmetry\Entities\EnumType\EnCommandType::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnCommandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commandType
     * @return \App\Symmetry\Entities\StructType\XML_SendDeviceCommandRequest
     */
    public function setCommandType($commandType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnCommandType::valueIsValid($commandType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnCommandType', is_array($commandType) ? implode(', ', $commandType) : var_export($commandType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnCommandType::getValidValues())), __LINE__);
        }
        $this->CommandType = $commandType;
        return $this;
    }
    /**
     * Get DeviceID value
     * @return int|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param int $deviceID
     * @return \App\Symmetry\Entities\StructType\XML_SendDeviceCommandRequest
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: int
        if (!is_null($deviceID) && !(is_int($deviceID) || ctype_digit($deviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceID, true), gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \App\Symmetry\Entities\StructType\XML_SendDeviceCommandRequest
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get TailInfoOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTailInfoOption()
    {
        return isset($this->TailInfoOption) ? $this->TailInfoOption : null;
    }
    /**
     * Set TailInfoOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tailInfoOption
     * @return \App\Symmetry\Entities\StructType\XML_SendDeviceCommandRequest
     */
    public function setTailInfoOption($tailInfoOption = null)
    {
        // validation for constraint: string
        if (!is_null($tailInfoOption) && !is_string($tailInfoOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tailInfoOption, true), gettype($tailInfoOption)), __LINE__);
        }
        if (is_null($tailInfoOption) || (is_array($tailInfoOption) && empty($tailInfoOption))) {
            unset($this->TailInfoOption);
        } else {
            $this->TailInfoOption = $tailInfoOption;
        }
        return $this;
    }
    /**
     * Get TailStructureNumber value
     * @return int|null
     */
    public function getTailStructureNumber()
    {
        return $this->TailStructureNumber;
    }
    /**
     * Set TailStructureNumber value
     * @param int $tailStructureNumber
     * @return \App\Symmetry\Entities\StructType\XML_SendDeviceCommandRequest
     */
    public function setTailStructureNumber($tailStructureNumber = null)
    {
        // validation for constraint: int
        if (!is_null($tailStructureNumber) && !(is_int($tailStructureNumber) || ctype_digit($tailStructureNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tailStructureNumber, true), gettype($tailStructureNumber)), __LINE__);
        }
        $this->TailStructureNumber = $tailStructureNumber;
        return $this;
    }
    /**
     * Get Value1 value
     * @return int|null
     */
    public function getValue1()
    {
        return $this->Value1;
    }
    /**
     * Set Value1 value
     * @param int $value1
     * @return \App\Symmetry\Entities\StructType\XML_SendDeviceCommandRequest
     */
    public function setValue1($value1 = null)
    {
        // validation for constraint: int
        if (!is_null($value1) && !(is_int($value1) || ctype_digit($value1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value1, true), gettype($value1)), __LINE__);
        }
        $this->Value1 = $value1;
        return $this;
    }
    /**
     * Get Value2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue2()
    {
        return isset($this->Value2) ? $this->Value2 : null;
    }
    /**
     * Set Value2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value2
     * @return \App\Symmetry\Entities\StructType\XML_SendDeviceCommandRequest
     */
    public function setValue2($value2 = null)
    {
        // validation for constraint: string
        if (!is_null($value2) && !is_string($value2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value2, true), gettype($value2)), __LINE__);
        }
        if (is_null($value2) || (is_array($value2) && empty($value2))) {
            unset($this->Value2);
        } else {
            $this->Value2 = $value2;
        }
        return $this;
    }
}
