<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_RenameRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_RenameRequest
 * @subpackage Structs
 */
class XML_RenameRequest extends AbstractStructBase
{
    /**
     * The DeviceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceID;
    /**
     * The DeviceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceName;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeviceType;
    /**
     * Constructor method for XML_RenameRequest
     * @uses XML_RenameRequest::setDeviceID()
     * @uses XML_RenameRequest::setDeviceName()
     * @uses XML_RenameRequest::setDeviceType()
     * @param int $deviceID
     * @param string $deviceName
     * @param string $deviceType
     */
    public function __construct($deviceID = null, $deviceName = null, $deviceType = null)
    {
        $this
            ->setDeviceID($deviceID)
            ->setDeviceName($deviceName)
            ->setDeviceType($deviceType);
    }
    /**
     * Get DeviceID value
     * @return int|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param int $deviceID
     * @return \App\Symmetry\Entities\StructType\XML_RenameRequest
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: int
        if (!is_null($deviceID) && !(is_int($deviceID) || ctype_digit($deviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceID, true), gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get DeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceName()
    {
        return isset($this->DeviceName) ? $this->DeviceName : null;
    }
    /**
     * Set DeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceName
     * @return \App\Symmetry\Entities\StructType\XML_RenameRequest
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceName, true), gettype($deviceName)), __LINE__);
        }
        if (is_null($deviceName) || (is_array($deviceName) && empty($deviceName))) {
            unset($this->DeviceName);
        } else {
            $this->DeviceName = $deviceName;
        }
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \App\Symmetry\Entities\StructType\XML_RenameRequest
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
}
