<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_LastReaderUsedForCardHolder StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_LastReaderUsedForCardHolder
 * @subpackage Structs
 */
class XML_LastReaderUsedForCardHolder extends AbstractStructBase
{
    /**
     * The DateTimeOfTxn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeOfTxn;
    /**
     * The ReaderDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReaderDescription;
    /**
     * The ReaderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderID;
    /**
     * The TimeZoneCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZoneCode;
    /**
     * Constructor method for XML_LastReaderUsedForCardHolder
     * @uses XML_LastReaderUsedForCardHolder::setDateTimeOfTxn()
     * @uses XML_LastReaderUsedForCardHolder::setReaderDescription()
     * @uses XML_LastReaderUsedForCardHolder::setReaderID()
     * @uses XML_LastReaderUsedForCardHolder::setTimeZoneCode()
     * @param string $dateTimeOfTxn
     * @param string $readerDescription
     * @param int $readerID
     * @param string $timeZoneCode
     */
    public function __construct($dateTimeOfTxn = null, $readerDescription = null, $readerID = null, $timeZoneCode = null)
    {
        $this
            ->setDateTimeOfTxn($dateTimeOfTxn)
            ->setReaderDescription($readerDescription)
            ->setReaderID($readerID)
            ->setTimeZoneCode($timeZoneCode);
    }
    /**
     * Get DateTimeOfTxn value
     * @return string|null
     */
    public function getDateTimeOfTxn()
    {
        return $this->DateTimeOfTxn;
    }
    /**
     * Set DateTimeOfTxn value
     * @param string $dateTimeOfTxn
     * @return \App\Symmetry\Entities\StructType\XML_LastReaderUsedForCardHolder
     */
    public function setDateTimeOfTxn($dateTimeOfTxn = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeOfTxn) && !is_string($dateTimeOfTxn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeOfTxn, true), gettype($dateTimeOfTxn)), __LINE__);
        }
        $this->DateTimeOfTxn = $dateTimeOfTxn;
        return $this;
    }
    /**
     * Get ReaderDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReaderDescription()
    {
        return isset($this->ReaderDescription) ? $this->ReaderDescription : null;
    }
    /**
     * Set ReaderDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $readerDescription
     * @return \App\Symmetry\Entities\StructType\XML_LastReaderUsedForCardHolder
     */
    public function setReaderDescription($readerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($readerDescription) && !is_string($readerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readerDescription, true), gettype($readerDescription)), __LINE__);
        }
        if (is_null($readerDescription) || (is_array($readerDescription) && empty($readerDescription))) {
            unset($this->ReaderDescription);
        } else {
            $this->ReaderDescription = $readerDescription;
        }
        return $this;
    }
    /**
     * Get ReaderID value
     * @return int|null
     */
    public function getReaderID()
    {
        return $this->ReaderID;
    }
    /**
     * Set ReaderID value
     * @param int $readerID
     * @return \App\Symmetry\Entities\StructType\XML_LastReaderUsedForCardHolder
     */
    public function setReaderID($readerID = null)
    {
        // validation for constraint: int
        if (!is_null($readerID) && !(is_int($readerID) || ctype_digit($readerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerID, true), gettype($readerID)), __LINE__);
        }
        $this->ReaderID = $readerID;
        return $this;
    }
    /**
     * Get TimeZoneCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZoneCode()
    {
        return isset($this->TimeZoneCode) ? $this->TimeZoneCode : null;
    }
    /**
     * Set TimeZoneCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZoneCode
     * @return \App\Symmetry\Entities\StructType\XML_LastReaderUsedForCardHolder
     */
    public function setTimeZoneCode($timeZoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneCode) && !is_string($timeZoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneCode, true), gettype($timeZoneCode)), __LINE__);
        }
        if (is_null($timeZoneCode) || (is_array($timeZoneCode) && empty($timeZoneCode))) {
            unset($this->TimeZoneCode);
        } else {
            $this->TimeZoneCode = $timeZoneCode;
        }
        return $this;
    }
}
