<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_LastCardTransactionsForAReaderRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_LastCardTransactionsForAReaderRequest
 * @subpackage Structs
 */
class XML_LastCardTransactionsForAReaderRequest extends AbstractStructBase
{
    /**
     * The NumberOfTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfTransactions;
    /**
     * The ReaderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderID;
    /**
     * Constructor method for XML_LastCardTransactionsForAReaderRequest
     * @uses XML_LastCardTransactionsForAReaderRequest::setNumberOfTransactions()
     * @uses XML_LastCardTransactionsForAReaderRequest::setReaderID()
     * @param int $numberOfTransactions
     * @param int $readerID
     */
    public function __construct($numberOfTransactions = null, $readerID = null)
    {
        $this
            ->setNumberOfTransactions($numberOfTransactions)
            ->setReaderID($readerID);
    }
    /**
     * Get NumberOfTransactions value
     * @return int|null
     */
    public function getNumberOfTransactions()
    {
        return $this->NumberOfTransactions;
    }
    /**
     * Set NumberOfTransactions value
     * @param int $numberOfTransactions
     * @return \App\Symmetry\Entities\StructType\XML_LastCardTransactionsForAReaderRequest
     */
    public function setNumberOfTransactions($numberOfTransactions = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTransactions) && !(is_int($numberOfTransactions) || ctype_digit($numberOfTransactions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTransactions, true), gettype($numberOfTransactions)), __LINE__);
        }
        $this->NumberOfTransactions = $numberOfTransactions;
        return $this;
    }
    /**
     * Get ReaderID value
     * @return int|null
     */
    public function getReaderID()
    {
        return $this->ReaderID;
    }
    /**
     * Set ReaderID value
     * @param int $readerID
     * @return \App\Symmetry\Entities\StructType\XML_LastCardTransactionsForAReaderRequest
     */
    public function setReaderID($readerID = null)
    {
        // validation for constraint: int
        if (!is_null($readerID) && !(is_int($readerID) || ctype_digit($readerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerID, true), gettype($readerID)), __LINE__);
        }
        $this->ReaderID = $readerID;
        return $this;
    }
}
