<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_LastCardTransactionsForAReaderGroupRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_LastCardTransactionsForAReaderGroupRequest
 * @subpackage Structs
 */
class XML_LastCardTransactionsForAReaderGroupRequest extends AbstractStructBase
{
    /**
     * The NumberOfTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfTransactions;
    /**
     * The ReaderGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderGroupID;
    /**
     * Constructor method for XML_LastCardTransactionsForAReaderGroupRequest
     * @uses XML_LastCardTransactionsForAReaderGroupRequest::setNumberOfTransactions()
     * @uses XML_LastCardTransactionsForAReaderGroupRequest::setReaderGroupID()
     * @param int $numberOfTransactions
     * @param int $readerGroupID
     */
    public function __construct($numberOfTransactions = null, $readerGroupID = null)
    {
        $this
            ->setNumberOfTransactions($numberOfTransactions)
            ->setReaderGroupID($readerGroupID);
    }
    /**
     * Get NumberOfTransactions value
     * @return int|null
     */
    public function getNumberOfTransactions()
    {
        return $this->NumberOfTransactions;
    }
    /**
     * Set NumberOfTransactions value
     * @param int $numberOfTransactions
     * @return \App\Symmetry\Entities\StructType\XML_LastCardTransactionsForAReaderGroupRequest
     */
    public function setNumberOfTransactions($numberOfTransactions = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTransactions) && !(is_int($numberOfTransactions) || ctype_digit($numberOfTransactions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTransactions, true), gettype($numberOfTransactions)), __LINE__);
        }
        $this->NumberOfTransactions = $numberOfTransactions;
        return $this;
    }
    /**
     * Get ReaderGroupID value
     * @return int|null
     */
    public function getReaderGroupID()
    {
        return $this->ReaderGroupID;
    }
    /**
     * Set ReaderGroupID value
     * @param int $readerGroupID
     * @return \App\Symmetry\Entities\StructType\XML_LastCardTransactionsForAReaderGroupRequest
     */
    public function setReaderGroupID($readerGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($readerGroupID) && !(is_int($readerGroupID) || ctype_digit($readerGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerGroupID, true), gettype($readerGroupID)), __LINE__);
        }
        $this->ReaderGroupID = $readerGroupID;
        return $this;
    }
}
