<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_ImportRecordRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_ImportRecordRequest
 * @subpackage Structs
 */
class XML_ImportRecordRequest extends AbstractStructBase
{
    /**
     * The ImportRecordRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImportRecordRequest;
    /**
     * The ImportRecordRequestDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportRecordRequestDescription;
    /**
     * Constructor method for XML_ImportRecordRequest
     * @uses XML_ImportRecordRequest::setImportRecordRequest()
     * @uses XML_ImportRecordRequest::setImportRecordRequestDescription()
     * @param string $importRecordRequest
     * @param string $importRecordRequestDescription
     */
    public function __construct($importRecordRequest = null, $importRecordRequestDescription = null)
    {
        $this
            ->setImportRecordRequest($importRecordRequest)
            ->setImportRecordRequestDescription($importRecordRequestDescription);
    }
    /**
     * Get ImportRecordRequest value
     * @return string|null
     */
    public function getImportRecordRequest()
    {
        return $this->ImportRecordRequest;
    }
    /**
     * Set ImportRecordRequest value
     * @uses \App\Symmetry\Entities\EnumType\EnImportRecordRequest::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnImportRecordRequest::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importRecordRequest
     * @return \App\Symmetry\Entities\StructType\XML_ImportRecordRequest
     */
    public function setImportRecordRequest($importRecordRequest = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnImportRecordRequest::valueIsValid($importRecordRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnImportRecordRequest', is_array($importRecordRequest) ? implode(', ', $importRecordRequest) : var_export($importRecordRequest, true), implode(', ', \App\Symmetry\Entities\EnumType\EnImportRecordRequest::getValidValues())), __LINE__);
        }
        $this->ImportRecordRequest = $importRecordRequest;
        return $this;
    }
    /**
     * Get ImportRecordRequestDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportRecordRequestDescription()
    {
        return isset($this->ImportRecordRequestDescription) ? $this->ImportRecordRequestDescription : null;
    }
    /**
     * Set ImportRecordRequestDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importRecordRequestDescription
     * @return \App\Symmetry\Entities\StructType\XML_ImportRecordRequest
     */
    public function setImportRecordRequestDescription($importRecordRequestDescription = null)
    {
        // validation for constraint: string
        if (!is_null($importRecordRequestDescription) && !is_string($importRecordRequestDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importRecordRequestDescription, true), gettype($importRecordRequestDescription)), __LINE__);
        }
        if (is_null($importRecordRequestDescription) || (is_array($importRecordRequestDescription) && empty($importRecordRequestDescription))) {
            unset($this->ImportRecordRequestDescription);
        } else {
            $this->ImportRecordRequestDescription = $importRecordRequestDescription;
        }
        return $this;
    }
}
