<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_ImportDataVisitorInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_ImportDataVisitorInfo
 * @subpackage Structs
 */
class XML_ImportDataVisitorInfo extends AbstractStructBase
{
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The BusinessCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessCard;
    /**
     * The ContactNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactNumber;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Representing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Representing;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Vehicle;
    /**
     * The Visiting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Visiting;
    /**
     * Constructor method for XML_ImportDataVisitorInfo
     * @uses XML_ImportDataVisitorInfo::setArrivalDateTime()
     * @uses XML_ImportDataVisitorInfo::setBusinessCard()
     * @uses XML_ImportDataVisitorInfo::setContactNumber()
     * @uses XML_ImportDataVisitorInfo::setDepartureDateTime()
     * @uses XML_ImportDataVisitorInfo::setMessage()
     * @uses XML_ImportDataVisitorInfo::setRepresenting()
     * @uses XML_ImportDataVisitorInfo::setVehicle()
     * @uses XML_ImportDataVisitorInfo::setVisiting()
     * @param string $arrivalDateTime
     * @param string $businessCard
     * @param string $contactNumber
     * @param string $departureDateTime
     * @param string $message
     * @param string $representing
     * @param string $vehicle
     * @param string $visiting
     */
    public function __construct($arrivalDateTime = null, $businessCard = null, $contactNumber = null, $departureDateTime = null, $message = null, $representing = null, $vehicle = null, $visiting = null)
    {
        $this
            ->setArrivalDateTime($arrivalDateTime)
            ->setBusinessCard($businessCard)
            ->setContactNumber($contactNumber)
            ->setDepartureDateTime($departureDateTime)
            ->setMessage($message)
            ->setRepresenting($representing)
            ->setVehicle($vehicle)
            ->setVisiting($visiting);
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataVisitorInfo
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get BusinessCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessCard()
    {
        return isset($this->BusinessCard) ? $this->BusinessCard : null;
    }
    /**
     * Set BusinessCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessCard
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataVisitorInfo
     */
    public function setBusinessCard($businessCard = null)
    {
        // validation for constraint: string
        if (!is_null($businessCard) && !is_string($businessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessCard, true), gettype($businessCard)), __LINE__);
        }
        if (is_null($businessCard) || (is_array($businessCard) && empty($businessCard))) {
            unset($this->BusinessCard);
        } else {
            $this->BusinessCard = $businessCard;
        }
        return $this;
    }
    /**
     * Get ContactNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactNumber()
    {
        return isset($this->ContactNumber) ? $this->ContactNumber : null;
    }
    /**
     * Set ContactNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactNumber
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataVisitorInfo
     */
    public function setContactNumber($contactNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contactNumber) && !is_string($contactNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactNumber, true), gettype($contactNumber)), __LINE__);
        }
        if (is_null($contactNumber) || (is_array($contactNumber) && empty($contactNumber))) {
            unset($this->ContactNumber);
        } else {
            $this->ContactNumber = $contactNumber;
        }
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataVisitorInfo
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataVisitorInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Representing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRepresenting()
    {
        return isset($this->Representing) ? $this->Representing : null;
    }
    /**
     * Set Representing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $representing
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataVisitorInfo
     */
    public function setRepresenting($representing = null)
    {
        // validation for constraint: string
        if (!is_null($representing) && !is_string($representing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($representing, true), gettype($representing)), __LINE__);
        }
        if (is_null($representing) || (is_array($representing) && empty($representing))) {
            unset($this->Representing);
        } else {
            $this->Representing = $representing;
        }
        return $this;
    }
    /**
     * Get Vehicle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVehicle()
    {
        return isset($this->Vehicle) ? $this->Vehicle : null;
    }
    /**
     * Set Vehicle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vehicle
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataVisitorInfo
     */
    public function setVehicle($vehicle = null)
    {
        // validation for constraint: string
        if (!is_null($vehicle) && !is_string($vehicle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicle, true), gettype($vehicle)), __LINE__);
        }
        if (is_null($vehicle) || (is_array($vehicle) && empty($vehicle))) {
            unset($this->Vehicle);
        } else {
            $this->Vehicle = $vehicle;
        }
        return $this;
    }
    /**
     * Get Visiting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisiting()
    {
        return isset($this->Visiting) ? $this->Visiting : null;
    }
    /**
     * Set Visiting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visiting
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataVisitorInfo
     */
    public function setVisiting($visiting = null)
    {
        // validation for constraint: string
        if (!is_null($visiting) && !is_string($visiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visiting, true), gettype($visiting)), __LINE__);
        }
        if (is_null($visiting) || (is_array($visiting) && empty($visiting))) {
            unset($this->Visiting);
        } else {
            $this->Visiting = $visiting;
        }
        return $this;
    }
}
