<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_ImportDataPersonalData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_ImportDataPersonalData
 * @subpackage Structs
 */
class XML_ImportDataPersonalData extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data;
    /**
     * The PersonalDataID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonalDataID;
    /**
     * Constructor method for XML_ImportDataPersonalData
     * @uses XML_ImportDataPersonalData::setData()
     * @uses XML_ImportDataPersonalData::setPersonalDataID()
     * @param string $data
     * @param int $personalDataID
     */
    public function __construct($data = null, $personalDataID = null)
    {
        $this
            ->setData($data)
            ->setPersonalDataID($personalDataID);
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataPersonalData
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get PersonalDataID value
     * @return int|null
     */
    public function getPersonalDataID()
    {
        return $this->PersonalDataID;
    }
    /**
     * Set PersonalDataID value
     * @param int $personalDataID
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataPersonalData
     */
    public function setPersonalDataID($personalDataID = null)
    {
        // validation for constraint: int
        if (!is_null($personalDataID) && !(is_int($personalDataID) || ctype_digit($personalDataID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personalDataID, true), gettype($personalDataID)), __LINE__);
        }
        $this->PersonalDataID = $personalDataID;
        return $this;
    }
}
