<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_ImportDataCardInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_ImportDataCardInfo
 * @subpackage Structs
 */
class XML_ImportDataCardInfo extends AbstractStructBase
{
    /**
     * The ActiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActiveDate;
    /**
     * The AgencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AgencyCode;
    /**
     * The BadgeFormatID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BadgeFormatID;
    /**
     * The CardFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CardFormat;
    /**
     * The CardIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardIdentifier;
    /**
     * The CardIssueLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CardIssueLevel;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardNumber;
    /**
     * The CredentialIssueLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CredentialIssueLevel;
    /**
     * The CredentialNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CredentialNumber;
    /**
     * The CredentialSeriesCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CredentialSeriesCode;
    /**
     * The CustomerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerCode;
    /**
     * The Encryption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Encryption;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The ExtendedPIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedPIN;
    /**
     * The IDSCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDSCode;
    /**
     * The InactiveComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InactiveComment;
    /**
     * The Lost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Lost;
    /**
     * The OrganisationAssociation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrganisationAssociation;
    /**
     * The OrganisationCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrganisationCategory;
    /**
     * The OrganisationIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrganisationIdentifier;
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PIN;
    /**
     * The PersonIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonIdentifier;
    /**
     * The SystemCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SystemCode;
    /**
     * Constructor method for XML_ImportDataCardInfo
     * @uses XML_ImportDataCardInfo::setActiveDate()
     * @uses XML_ImportDataCardInfo::setAgencyCode()
     * @uses XML_ImportDataCardInfo::setBadgeFormatID()
     * @uses XML_ImportDataCardInfo::setCardFormat()
     * @uses XML_ImportDataCardInfo::setCardIdentifier()
     * @uses XML_ImportDataCardInfo::setCardIssueLevel()
     * @uses XML_ImportDataCardInfo::setCardNumber()
     * @uses XML_ImportDataCardInfo::setCredentialIssueLevel()
     * @uses XML_ImportDataCardInfo::setCredentialNumber()
     * @uses XML_ImportDataCardInfo::setCredentialSeriesCode()
     * @uses XML_ImportDataCardInfo::setCustomerCode()
     * @uses XML_ImportDataCardInfo::setEncryption()
     * @uses XML_ImportDataCardInfo::setExpiryDate()
     * @uses XML_ImportDataCardInfo::setExtendedPIN()
     * @uses XML_ImportDataCardInfo::setIDSCode()
     * @uses XML_ImportDataCardInfo::setInactiveComment()
     * @uses XML_ImportDataCardInfo::setLost()
     * @uses XML_ImportDataCardInfo::setOrganisationAssociation()
     * @uses XML_ImportDataCardInfo::setOrganisationCategory()
     * @uses XML_ImportDataCardInfo::setOrganisationIdentifier()
     * @uses XML_ImportDataCardInfo::setPIN()
     * @uses XML_ImportDataCardInfo::setPersonIdentifier()
     * @uses XML_ImportDataCardInfo::setSystemCode()
     * @param string $activeDate
     * @param int $agencyCode
     * @param int $badgeFormatID
     * @param string $cardFormat
     * @param string $cardIdentifier
     * @param string $cardIssueLevel
     * @param int $cardNumber
     * @param string $credentialIssueLevel
     * @param int $credentialNumber
     * @param int $credentialSeriesCode
     * @param int $customerCode
     * @param int $encryption
     * @param string $expiryDate
     * @param string $extendedPIN
     * @param string $iDSCode
     * @param string $inactiveComment
     * @param bool $lost
     * @param int $organisationAssociation
     * @param int $organisationCategory
     * @param int $organisationIdentifier
     * @param int $pIN
     * @param int $personIdentifier
     * @param int $systemCode
     */
    public function __construct($activeDate = null, $agencyCode = null, $badgeFormatID = null, $cardFormat = null, $cardIdentifier = null, $cardIssueLevel = null, $cardNumber = null, $credentialIssueLevel = null, $credentialNumber = null, $credentialSeriesCode = null, $customerCode = null, $encryption = null, $expiryDate = null, $extendedPIN = null, $iDSCode = null, $inactiveComment = null, $lost = null, $organisationAssociation = null, $organisationCategory = null, $organisationIdentifier = null, $pIN = null, $personIdentifier = null, $systemCode = null)
    {
        $this
            ->setActiveDate($activeDate)
            ->setAgencyCode($agencyCode)
            ->setBadgeFormatID($badgeFormatID)
            ->setCardFormat($cardFormat)
            ->setCardIdentifier($cardIdentifier)
            ->setCardIssueLevel($cardIssueLevel)
            ->setCardNumber($cardNumber)
            ->setCredentialIssueLevel($credentialIssueLevel)
            ->setCredentialNumber($credentialNumber)
            ->setCredentialSeriesCode($credentialSeriesCode)
            ->setCustomerCode($customerCode)
            ->setEncryption($encryption)
            ->setExpiryDate($expiryDate)
            ->setExtendedPIN($extendedPIN)
            ->setIDSCode($iDSCode)
            ->setInactiveComment($inactiveComment)
            ->setLost($lost)
            ->setOrganisationAssociation($organisationAssociation)
            ->setOrganisationCategory($organisationCategory)
            ->setOrganisationIdentifier($organisationIdentifier)
            ->setPIN($pIN)
            ->setPersonIdentifier($personIdentifier)
            ->setSystemCode($systemCode);
    }
    /**
     * Get ActiveDate value
     * @return string|null
     */
    public function getActiveDate()
    {
        return $this->ActiveDate;
    }
    /**
     * Set ActiveDate value
     * @param string $activeDate
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setActiveDate($activeDate = null)
    {
        // validation for constraint: string
        if (!is_null($activeDate) && !is_string($activeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeDate, true), gettype($activeDate)), __LINE__);
        }
        $this->ActiveDate = $activeDate;
        return $this;
    }
    /**
     * Get AgencyCode value
     * @return int|null
     */
    public function getAgencyCode()
    {
        return $this->AgencyCode;
    }
    /**
     * Set AgencyCode value
     * @param int $agencyCode
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setAgencyCode($agencyCode = null)
    {
        // validation for constraint: int
        if (!is_null($agencyCode) && !(is_int($agencyCode) || ctype_digit($agencyCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencyCode, true), gettype($agencyCode)), __LINE__);
        }
        $this->AgencyCode = $agencyCode;
        return $this;
    }
    /**
     * Get BadgeFormatID value
     * @return int|null
     */
    public function getBadgeFormatID()
    {
        return $this->BadgeFormatID;
    }
    /**
     * Set BadgeFormatID value
     * @param int $badgeFormatID
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setBadgeFormatID($badgeFormatID = null)
    {
        // validation for constraint: int
        if (!is_null($badgeFormatID) && !(is_int($badgeFormatID) || ctype_digit($badgeFormatID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($badgeFormatID, true), gettype($badgeFormatID)), __LINE__);
        }
        $this->BadgeFormatID = $badgeFormatID;
        return $this;
    }
    /**
     * Get CardFormat value
     * @return string|null
     */
    public function getCardFormat()
    {
        return $this->CardFormat;
    }
    /**
     * Set CardFormat value
     * @uses \App\Symmetry\Entities\EnumType\EnCardFormat::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnCardFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardFormat
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setCardFormat($cardFormat = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnCardFormat::valueIsValid($cardFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnCardFormat', is_array($cardFormat) ? implode(', ', $cardFormat) : var_export($cardFormat, true), implode(', ', \App\Symmetry\Entities\EnumType\EnCardFormat::getValidValues())), __LINE__);
        }
        $this->CardFormat = $cardFormat;
        return $this;
    }
    /**
     * Get CardIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardIdentifier()
    {
        return isset($this->CardIdentifier) ? $this->CardIdentifier : null;
    }
    /**
     * Set CardIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardIdentifier
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setCardIdentifier($cardIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($cardIdentifier) && !is_string($cardIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIdentifier, true), gettype($cardIdentifier)), __LINE__);
        }
        if (is_null($cardIdentifier) || (is_array($cardIdentifier) && empty($cardIdentifier))) {
            unset($this->CardIdentifier);
        } else {
            $this->CardIdentifier = $cardIdentifier;
        }
        return $this;
    }
    /**
     * Get CardIssueLevel value
     * @return string|null
     */
    public function getCardIssueLevel()
    {
        return $this->CardIssueLevel;
    }
    /**
     * Set CardIssueLevel value
     * @param string $cardIssueLevel
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setCardIssueLevel($cardIssueLevel = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssueLevel) && !is_string($cardIssueLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssueLevel, true), gettype($cardIssueLevel)), __LINE__);
        }
        $this->CardIssueLevel = $cardIssueLevel;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return int|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param int $cardNumber
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($cardNumber) && !(is_int($cardNumber) || ctype_digit($cardNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CredentialIssueLevel value
     * @return string|null
     */
    public function getCredentialIssueLevel()
    {
        return $this->CredentialIssueLevel;
    }
    /**
     * Set CredentialIssueLevel value
     * @param string $credentialIssueLevel
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setCredentialIssueLevel($credentialIssueLevel = null)
    {
        // validation for constraint: string
        if (!is_null($credentialIssueLevel) && !is_string($credentialIssueLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credentialIssueLevel, true), gettype($credentialIssueLevel)), __LINE__);
        }
        $this->CredentialIssueLevel = $credentialIssueLevel;
        return $this;
    }
    /**
     * Get CredentialNumber value
     * @return int|null
     */
    public function getCredentialNumber()
    {
        return $this->CredentialNumber;
    }
    /**
     * Set CredentialNumber value
     * @param int $credentialNumber
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setCredentialNumber($credentialNumber = null)
    {
        // validation for constraint: int
        if (!is_null($credentialNumber) && !(is_int($credentialNumber) || ctype_digit($credentialNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($credentialNumber, true), gettype($credentialNumber)), __LINE__);
        }
        $this->CredentialNumber = $credentialNumber;
        return $this;
    }
    /**
     * Get CredentialSeriesCode value
     * @return int|null
     */
    public function getCredentialSeriesCode()
    {
        return $this->CredentialSeriesCode;
    }
    /**
     * Set CredentialSeriesCode value
     * @param int $credentialSeriesCode
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setCredentialSeriesCode($credentialSeriesCode = null)
    {
        // validation for constraint: int
        if (!is_null($credentialSeriesCode) && !(is_int($credentialSeriesCode) || ctype_digit($credentialSeriesCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($credentialSeriesCode, true), gettype($credentialSeriesCode)), __LINE__);
        }
        $this->CredentialSeriesCode = $credentialSeriesCode;
        return $this;
    }
    /**
     * Get CustomerCode value
     * @return int|null
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }
    /**
     * Set CustomerCode value
     * @param int $customerCode
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: int
        if (!is_null($customerCode) && !(is_int($customerCode) || ctype_digit($customerCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerCode, true), gettype($customerCode)), __LINE__);
        }
        $this->CustomerCode = $customerCode;
        return $this;
    }
    /**
     * Get Encryption value
     * @return int|null
     */
    public function getEncryption()
    {
        return $this->Encryption;
    }
    /**
     * Set Encryption value
     * @param int $encryption
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setEncryption($encryption = null)
    {
        // validation for constraint: int
        if (!is_null($encryption) && !(is_int($encryption) || ctype_digit($encryption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($encryption, true), gettype($encryption)), __LINE__);
        }
        $this->Encryption = $encryption;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get ExtendedPIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedPIN()
    {
        return isset($this->ExtendedPIN) ? $this->ExtendedPIN : null;
    }
    /**
     * Set ExtendedPIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedPIN
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setExtendedPIN($extendedPIN = null)
    {
        // validation for constraint: string
        if (!is_null($extendedPIN) && !is_string($extendedPIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedPIN, true), gettype($extendedPIN)), __LINE__);
        }
        if (is_null($extendedPIN) || (is_array($extendedPIN) && empty($extendedPIN))) {
            unset($this->ExtendedPIN);
        } else {
            $this->ExtendedPIN = $extendedPIN;
        }
        return $this;
    }
    /**
     * Get IDSCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDSCode()
    {
        return isset($this->IDSCode) ? $this->IDSCode : null;
    }
    /**
     * Set IDSCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDSCode
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setIDSCode($iDSCode = null)
    {
        // validation for constraint: string
        if (!is_null($iDSCode) && !is_string($iDSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSCode, true), gettype($iDSCode)), __LINE__);
        }
        if (is_null($iDSCode) || (is_array($iDSCode) && empty($iDSCode))) {
            unset($this->IDSCode);
        } else {
            $this->IDSCode = $iDSCode;
        }
        return $this;
    }
    /**
     * Get InactiveComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInactiveComment()
    {
        return isset($this->InactiveComment) ? $this->InactiveComment : null;
    }
    /**
     * Set InactiveComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inactiveComment
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setInactiveComment($inactiveComment = null)
    {
        // validation for constraint: string
        if (!is_null($inactiveComment) && !is_string($inactiveComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inactiveComment, true), gettype($inactiveComment)), __LINE__);
        }
        if (is_null($inactiveComment) || (is_array($inactiveComment) && empty($inactiveComment))) {
            unset($this->InactiveComment);
        } else {
            $this->InactiveComment = $inactiveComment;
        }
        return $this;
    }
    /**
     * Get Lost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLost()
    {
        return isset($this->Lost) ? $this->Lost : null;
    }
    /**
     * Set Lost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $lost
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setLost($lost = null)
    {
        // validation for constraint: boolean
        if (!is_null($lost) && !is_bool($lost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lost, true), gettype($lost)), __LINE__);
        }
        if (is_null($lost) || (is_array($lost) && empty($lost))) {
            unset($this->Lost);
        } else {
            $this->Lost = $lost;
        }
        return $this;
    }
    /**
     * Get OrganisationAssociation value
     * @return int|null
     */
    public function getOrganisationAssociation()
    {
        return $this->OrganisationAssociation;
    }
    /**
     * Set OrganisationAssociation value
     * @param int $organisationAssociation
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setOrganisationAssociation($organisationAssociation = null)
    {
        // validation for constraint: int
        if (!is_null($organisationAssociation) && !(is_int($organisationAssociation) || ctype_digit($organisationAssociation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationAssociation, true), gettype($organisationAssociation)), __LINE__);
        }
        $this->OrganisationAssociation = $organisationAssociation;
        return $this;
    }
    /**
     * Get OrganisationCategory value
     * @return int|null
     */
    public function getOrganisationCategory()
    {
        return $this->OrganisationCategory;
    }
    /**
     * Set OrganisationCategory value
     * @param int $organisationCategory
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setOrganisationCategory($organisationCategory = null)
    {
        // validation for constraint: int
        if (!is_null($organisationCategory) && !(is_int($organisationCategory) || ctype_digit($organisationCategory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationCategory, true), gettype($organisationCategory)), __LINE__);
        }
        $this->OrganisationCategory = $organisationCategory;
        return $this;
    }
    /**
     * Get OrganisationIdentifier value
     * @return int|null
     */
    public function getOrganisationIdentifier()
    {
        return $this->OrganisationIdentifier;
    }
    /**
     * Set OrganisationIdentifier value
     * @param int $organisationIdentifier
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setOrganisationIdentifier($organisationIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($organisationIdentifier) && !(is_int($organisationIdentifier) || ctype_digit($organisationIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationIdentifier, true), gettype($organisationIdentifier)), __LINE__);
        }
        $this->OrganisationIdentifier = $organisationIdentifier;
        return $this;
    }
    /**
     * Get PIN value
     * @return int|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param int $pIN
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: int
        if (!is_null($pIN) && !(is_int($pIN) || ctype_digit($pIN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pIN, true), gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get PersonIdentifier value
     * @return int|null
     */
    public function getPersonIdentifier()
    {
        return $this->PersonIdentifier;
    }
    /**
     * Set PersonIdentifier value
     * @param int $personIdentifier
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setPersonIdentifier($personIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($personIdentifier) && !(is_int($personIdentifier) || ctype_digit($personIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personIdentifier, true), gettype($personIdentifier)), __LINE__);
        }
        $this->PersonIdentifier = $personIdentifier;
        return $this;
    }
    /**
     * Get SystemCode value
     * @return int|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * Set SystemCode value
     * @param int $systemCode
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardInfo
     */
    public function setSystemCode($systemCode = null)
    {
        // validation for constraint: int
        if (!is_null($systemCode) && !(is_int($systemCode) || ctype_digit($systemCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemCode, true), gettype($systemCode)), __LINE__);
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
}
