<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_ImportDataCardHolderStatusDocument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_ImportDataCardHolderStatusDocument
 * @subpackage Structs
 */
class XML_ImportDataCardHolderStatusDocument extends AbstractStructBase
{
    /**
     * The BatchReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchReference;
    /**
     * The CardHolderImportDataStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_ImportDataCardHolderStatus
     */
    public $CardHolderImportDataStatus;
    /**
     * Constructor method for XML_ImportDataCardHolderStatusDocument
     * @uses XML_ImportDataCardHolderStatusDocument::setBatchReference()
     * @uses XML_ImportDataCardHolderStatusDocument::setCardHolderImportDataStatus()
     * @param string $batchReference
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_ImportDataCardHolderStatus $cardHolderImportDataStatus
     */
    public function __construct($batchReference = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_ImportDataCardHolderStatus $cardHolderImportDataStatus = null)
    {
        $this
            ->setBatchReference($batchReference)
            ->setCardHolderImportDataStatus($cardHolderImportDataStatus);
    }
    /**
     * Get BatchReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchReference()
    {
        return isset($this->BatchReference) ? $this->BatchReference : null;
    }
    /**
     * Set BatchReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchReference
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatusDocument
     */
    public function setBatchReference($batchReference = null)
    {
        // validation for constraint: string
        if (!is_null($batchReference) && !is_string($batchReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchReference, true), gettype($batchReference)), __LINE__);
        }
        if (is_null($batchReference) || (is_array($batchReference) && empty($batchReference))) {
            unset($this->BatchReference);
        } else {
            $this->BatchReference = $batchReference;
        }
        return $this;
    }
    /**
     * Get CardHolderImportDataStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_ImportDataCardHolderStatus|null
     */
    public function getCardHolderImportDataStatus()
    {
        return isset($this->CardHolderImportDataStatus) ? $this->CardHolderImportDataStatus : null;
    }
    /**
     * Set CardHolderImportDataStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_ImportDataCardHolderStatus $cardHolderImportDataStatus
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatusDocument
     */
    public function setCardHolderImportDataStatus(\App\Symmetry\Entities\ArrayType\ArrayOfXML_ImportDataCardHolderStatus $cardHolderImportDataStatus = null)
    {
        if (is_null($cardHolderImportDataStatus) || (is_array($cardHolderImportDataStatus) && empty($cardHolderImportDataStatus))) {
            unset($this->CardHolderImportDataStatus);
        } else {
            $this->CardHolderImportDataStatus = $cardHolderImportDataStatus;
        }
        return $this;
    }
}
