<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_EditReaderGroup StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_EditReaderGroup
 * @subpackage Structs
 */
class XML_EditReaderGroup extends AbstractStructBase
{
    /**
     * The ReaderGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderGroupID;
    /**
     * The TimeCodeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TimeCodeID;
    /**
     * Constructor method for XML_EditReaderGroup
     * @uses XML_EditReaderGroup::setReaderGroupID()
     * @uses XML_EditReaderGroup::setTimeCodeID()
     * @param int $readerGroupID
     * @param int $timeCodeID
     */
    public function __construct($readerGroupID = null, $timeCodeID = null)
    {
        $this
            ->setReaderGroupID($readerGroupID)
            ->setTimeCodeID($timeCodeID);
    }
    /**
     * Get ReaderGroupID value
     * @return int|null
     */
    public function getReaderGroupID()
    {
        return $this->ReaderGroupID;
    }
    /**
     * Set ReaderGroupID value
     * @param int $readerGroupID
     * @return \App\Symmetry\Entities\StructType\XML_EditReaderGroup
     */
    public function setReaderGroupID($readerGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($readerGroupID) && !(is_int($readerGroupID) || ctype_digit($readerGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerGroupID, true), gettype($readerGroupID)), __LINE__);
        }
        $this->ReaderGroupID = $readerGroupID;
        return $this;
    }
    /**
     * Get TimeCodeID value
     * @return int|null
     */
    public function getTimeCodeID()
    {
        return $this->TimeCodeID;
    }
    /**
     * Set TimeCodeID value
     * @param int $timeCodeID
     * @return \App\Symmetry\Entities\StructType\XML_EditReaderGroup
     */
    public function setTimeCodeID($timeCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($timeCodeID) && !(is_int($timeCodeID) || ctype_digit($timeCodeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeCodeID, true), gettype($timeCodeID)), __LINE__);
        }
        $this->TimeCodeID = $timeCodeID;
        return $this;
    }
}
