<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_DeviceType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_DeviceType
 * @subpackage Structs
 */
class XML_DeviceType extends AbstractStructBase
{
    /**
     * The TypeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeDescription;
    /**
     * The TypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TypeID;
    /**
     * Constructor method for XML_DeviceType
     * @uses XML_DeviceType::setTypeDescription()
     * @uses XML_DeviceType::setTypeID()
     * @param string $typeDescription
     * @param string $typeID
     */
    public function __construct($typeDescription = null, $typeID = null)
    {
        $this
            ->setTypeDescription($typeDescription)
            ->setTypeID($typeID);
    }
    /**
     * Get TypeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeDescription()
    {
        return isset($this->TypeDescription) ? $this->TypeDescription : null;
    }
    /**
     * Set TypeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeDescription
     * @return \App\Symmetry\Entities\StructType\XML_DeviceType
     */
    public function setTypeDescription($typeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeDescription) && !is_string($typeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDescription, true), gettype($typeDescription)), __LINE__);
        }
        if (is_null($typeDescription) || (is_array($typeDescription) && empty($typeDescription))) {
            unset($this->TypeDescription);
        } else {
            $this->TypeDescription = $typeDescription;
        }
        return $this;
    }
    /**
     * Get TypeID value
     * @return string|null
     */
    public function getTypeID()
    {
        return $this->TypeID;
    }
    /**
     * Set TypeID value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeID
     * @return \App\Symmetry\Entities\StructType\XML_DeviceType
     */
    public function setTypeID($typeID = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($typeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($typeID) ? implode(', ', $typeID) : var_export($typeID, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->TypeID = $typeID;
        return $this;
    }
}
