<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_DeviceCommand StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_DeviceCommand
 * @subpackage Structs
 */
class XML_DeviceCommand extends AbstractStructBase
{
    /**
     * The Commands
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_Command
     */
    public $Commands;
    /**
     * The DeviceDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceDescription;
    /**
     * The DeviceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceID;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeviceType;
    /**
     * Constructor method for XML_DeviceCommand
     * @uses XML_DeviceCommand::setCommands()
     * @uses XML_DeviceCommand::setDeviceDescription()
     * @uses XML_DeviceCommand::setDeviceID()
     * @uses XML_DeviceCommand::setDeviceType()
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_Command $commands
     * @param string $deviceDescription
     * @param int $deviceID
     * @param string $deviceType
     */
    public function __construct(\App\Symmetry\Entities\ArrayType\ArrayOfXML_Command $commands = null, $deviceDescription = null, $deviceID = null, $deviceType = null)
    {
        $this
            ->setCommands($commands)
            ->setDeviceDescription($deviceDescription)
            ->setDeviceID($deviceID)
            ->setDeviceType($deviceType);
    }
    /**
     * Get Commands value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_Command|null
     */
    public function getCommands()
    {
        return isset($this->Commands) ? $this->Commands : null;
    }
    /**
     * Set Commands value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_Command $commands
     * @return \App\Symmetry\Entities\StructType\XML_DeviceCommand
     */
    public function setCommands(\App\Symmetry\Entities\ArrayType\ArrayOfXML_Command $commands = null)
    {
        if (is_null($commands) || (is_array($commands) && empty($commands))) {
            unset($this->Commands);
        } else {
            $this->Commands = $commands;
        }
        return $this;
    }
    /**
     * Get DeviceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceDescription()
    {
        return isset($this->DeviceDescription) ? $this->DeviceDescription : null;
    }
    /**
     * Set DeviceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceDescription
     * @return \App\Symmetry\Entities\StructType\XML_DeviceCommand
     */
    public function setDeviceDescription($deviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDescription) && !is_string($deviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceDescription, true), gettype($deviceDescription)), __LINE__);
        }
        if (is_null($deviceDescription) || (is_array($deviceDescription) && empty($deviceDescription))) {
            unset($this->DeviceDescription);
        } else {
            $this->DeviceDescription = $deviceDescription;
        }
        return $this;
    }
    /**
     * Get DeviceID value
     * @return int|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param int $deviceID
     * @return \App\Symmetry\Entities\StructType\XML_DeviceCommand
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: int
        if (!is_null($deviceID) && !(is_int($deviceID) || ctype_digit($deviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceID, true), gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \App\Symmetry\Entities\StructType\XML_DeviceCommand
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
}
