<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_DataTitleRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_DataTitleRequest
 * @subpackage Structs
 */
class XML_DataTitleRequest extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The Visitors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Visitors;
    /**
     * Constructor method for XML_DataTitleRequest
     * @uses XML_DataTitleRequest::setCompanyID()
     * @uses XML_DataTitleRequest::setVisitors()
     * @param int $companyID
     * @param bool $visitors
     */
    public function __construct($companyID = null, $visitors = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setVisitors($visitors);
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_DataTitleRequest
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get Visitors value
     * @return bool|null
     */
    public function getVisitors()
    {
        return $this->Visitors;
    }
    /**
     * Set Visitors value
     * @param bool $visitors
     * @return \App\Symmetry\Entities\StructType\XML_DataTitleRequest
     */
    public function setVisitors($visitors = null)
    {
        // validation for constraint: boolean
        if (!is_null($visitors) && !is_bool($visitors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visitors, true), gettype($visitors)), __LINE__);
        }
        $this->Visitors = $visitors;
        return $this;
    }
}
