<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_DataTitle StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_DataTitle
 * @subpackage Structs
 */
class XML_DataTitle extends AbstractStructBase
{
    /**
     * The CategoryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CategoryType;
    /**
     * The DataTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataTitle;
    /**
     * The DataTitleID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DataTitleID;
    /**
     * The FieldType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FieldType;
    /**
     * The Mandatory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Mandatory;
    /**
     * The Mask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mask;
    /**
     * Constructor method for XML_DataTitle
     * @uses XML_DataTitle::setCategoryType()
     * @uses XML_DataTitle::setDataTitle()
     * @uses XML_DataTitle::setDataTitleID()
     * @uses XML_DataTitle::setFieldType()
     * @uses XML_DataTitle::setMandatory()
     * @uses XML_DataTitle::setMask()
     * @param string $categoryType
     * @param string $dataTitle
     * @param int $dataTitleID
     * @param string $fieldType
     * @param bool $mandatory
     * @param string $mask
     */
    public function __construct($categoryType = null, $dataTitle = null, $dataTitleID = null, $fieldType = null, $mandatory = null, $mask = null)
    {
        $this
            ->setCategoryType($categoryType)
            ->setDataTitle($dataTitle)
            ->setDataTitleID($dataTitleID)
            ->setFieldType($fieldType)
            ->setMandatory($mandatory)
            ->setMask($mask);
    }
    /**
     * Get CategoryType value
     * @return string|null
     */
    public function getCategoryType()
    {
        return $this->CategoryType;
    }
    /**
     * Set CategoryType value
     * @uses \App\Symmetry\Entities\EnumType\EnCategoryType::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnCategoryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryType
     * @return \App\Symmetry\Entities\StructType\XML_DataTitle
     */
    public function setCategoryType($categoryType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnCategoryType::valueIsValid($categoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnCategoryType', is_array($categoryType) ? implode(', ', $categoryType) : var_export($categoryType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnCategoryType::getValidValues())), __LINE__);
        }
        $this->CategoryType = $categoryType;
        return $this;
    }
    /**
     * Get DataTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataTitle()
    {
        return isset($this->DataTitle) ? $this->DataTitle : null;
    }
    /**
     * Set DataTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataTitle
     * @return \App\Symmetry\Entities\StructType\XML_DataTitle
     */
    public function setDataTitle($dataTitle = null)
    {
        // validation for constraint: string
        if (!is_null($dataTitle) && !is_string($dataTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTitle, true), gettype($dataTitle)), __LINE__);
        }
        if (is_null($dataTitle) || (is_array($dataTitle) && empty($dataTitle))) {
            unset($this->DataTitle);
        } else {
            $this->DataTitle = $dataTitle;
        }
        return $this;
    }
    /**
     * Get DataTitleID value
     * @return int|null
     */
    public function getDataTitleID()
    {
        return $this->DataTitleID;
    }
    /**
     * Set DataTitleID value
     * @param int $dataTitleID
     * @return \App\Symmetry\Entities\StructType\XML_DataTitle
     */
    public function setDataTitleID($dataTitleID = null)
    {
        // validation for constraint: int
        if (!is_null($dataTitleID) && !(is_int($dataTitleID) || ctype_digit($dataTitleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataTitleID, true), gettype($dataTitleID)), __LINE__);
        }
        $this->DataTitleID = $dataTitleID;
        return $this;
    }
    /**
     * Get FieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->FieldType;
    }
    /**
     * Set FieldType value
     * @uses \App\Symmetry\Entities\EnumType\EnFieldType::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fieldType
     * @return \App\Symmetry\Entities\StructType\XML_DataTitle
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnFieldType::valueIsValid($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnFieldType', is_array($fieldType) ? implode(', ', $fieldType) : var_export($fieldType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnFieldType::getValidValues())), __LINE__);
        }
        $this->FieldType = $fieldType;
        return $this;
    }
    /**
     * Get Mandatory value
     * @return bool|null
     */
    public function getMandatory()
    {
        return $this->Mandatory;
    }
    /**
     * Set Mandatory value
     * @param bool $mandatory
     * @return \App\Symmetry\Entities\StructType\XML_DataTitle
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatory, true), gettype($mandatory)), __LINE__);
        }
        $this->Mandatory = $mandatory;
        return $this;
    }
    /**
     * Get Mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMask()
    {
        return isset($this->Mask) ? $this->Mask : null;
    }
    /**
     * Set Mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mask
     * @return \App\Symmetry\Entities\StructType\XML_DataTitle
     */
    public function setMask($mask = null)
    {
        // validation for constraint: string
        if (!is_null($mask) && !is_string($mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mask, true), gettype($mask)), __LINE__);
        }
        if (is_null($mask) || (is_array($mask) && empty($mask))) {
            unset($this->Mask);
        } else {
            $this->Mask = $mask;
        }
        return $this;
    }
}
