<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_Company StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_Company
 * @subpackage Structs
 */
class XML_Company extends AbstractStructBase
{
    /**
     * The CompanyDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyDescription;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * Constructor method for XML_Company
     * @uses XML_Company::setCompanyDescription()
     * @uses XML_Company::setCompanyID()
     * @param string $companyDescription
     * @param int $companyID
     */
    public function __construct($companyDescription = null, $companyID = null)
    {
        $this
            ->setCompanyDescription($companyDescription)
            ->setCompanyID($companyID);
    }
    /**
     * Get CompanyDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyDescription()
    {
        return isset($this->CompanyDescription) ? $this->CompanyDescription : null;
    }
    /**
     * Set CompanyDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyDescription
     * @return \App\Symmetry\Entities\StructType\XML_Company
     */
    public function setCompanyDescription($companyDescription = null)
    {
        // validation for constraint: string
        if (!is_null($companyDescription) && !is_string($companyDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyDescription, true), gettype($companyDescription)), __LINE__);
        }
        if (is_null($companyDescription) || (is_array($companyDescription) && empty($companyDescription))) {
            unset($this->CompanyDescription);
        } else {
            $this->CompanyDescription = $companyDescription;
        }
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_Company
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
}
