<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_Command StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_Command
 * @subpackage Structs
 */
class XML_Command extends AbstractStructBase
{
    /**
     * The CommandCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommandCode;
    /**
     * The CommandDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandDescription;
    /**
     * The CommandID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommandID;
    /**
     * The TailInfoOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TailInfoOption;
    /**
     * The TailStructureNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TailStructureNumber;
    /**
     * Constructor method for XML_Command
     * @uses XML_Command::setCommandCode()
     * @uses XML_Command::setCommandDescription()
     * @uses XML_Command::setCommandID()
     * @uses XML_Command::setTailInfoOption()
     * @uses XML_Command::setTailStructureNumber()
     * @param int $commandCode
     * @param string $commandDescription
     * @param int $commandID
     * @param string $tailInfoOption
     * @param int $tailStructureNumber
     */
    public function __construct($commandCode = null, $commandDescription = null, $commandID = null, $tailInfoOption = null, $tailStructureNumber = null)
    {
        $this
            ->setCommandCode($commandCode)
            ->setCommandDescription($commandDescription)
            ->setCommandID($commandID)
            ->setTailInfoOption($tailInfoOption)
            ->setTailStructureNumber($tailStructureNumber);
    }
    /**
     * Get CommandCode value
     * @return int|null
     */
    public function getCommandCode()
    {
        return $this->CommandCode;
    }
    /**
     * Set CommandCode value
     * @param int $commandCode
     * @return \App\Symmetry\Entities\StructType\XML_Command
     */
    public function setCommandCode($commandCode = null)
    {
        // validation for constraint: int
        if (!is_null($commandCode) && !(is_int($commandCode) || ctype_digit($commandCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commandCode, true), gettype($commandCode)), __LINE__);
        }
        $this->CommandCode = $commandCode;
        return $this;
    }
    /**
     * Get CommandDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandDescription()
    {
        return isset($this->CommandDescription) ? $this->CommandDescription : null;
    }
    /**
     * Set CommandDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandDescription
     * @return \App\Symmetry\Entities\StructType\XML_Command
     */
    public function setCommandDescription($commandDescription = null)
    {
        // validation for constraint: string
        if (!is_null($commandDescription) && !is_string($commandDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandDescription, true), gettype($commandDescription)), __LINE__);
        }
        if (is_null($commandDescription) || (is_array($commandDescription) && empty($commandDescription))) {
            unset($this->CommandDescription);
        } else {
            $this->CommandDescription = $commandDescription;
        }
        return $this;
    }
    /**
     * Get CommandID value
     * @return int|null
     */
    public function getCommandID()
    {
        return $this->CommandID;
    }
    /**
     * Set CommandID value
     * @param int $commandID
     * @return \App\Symmetry\Entities\StructType\XML_Command
     */
    public function setCommandID($commandID = null)
    {
        // validation for constraint: int
        if (!is_null($commandID) && !(is_int($commandID) || ctype_digit($commandID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commandID, true), gettype($commandID)), __LINE__);
        }
        $this->CommandID = $commandID;
        return $this;
    }
    /**
     * Get TailInfoOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTailInfoOption()
    {
        return isset($this->TailInfoOption) ? $this->TailInfoOption : null;
    }
    /**
     * Set TailInfoOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tailInfoOption
     * @return \App\Symmetry\Entities\StructType\XML_Command
     */
    public function setTailInfoOption($tailInfoOption = null)
    {
        // validation for constraint: string
        if (!is_null($tailInfoOption) && !is_string($tailInfoOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tailInfoOption, true), gettype($tailInfoOption)), __LINE__);
        }
        if (is_null($tailInfoOption) || (is_array($tailInfoOption) && empty($tailInfoOption))) {
            unset($this->TailInfoOption);
        } else {
            $this->TailInfoOption = $tailInfoOption;
        }
        return $this;
    }
    /**
     * Get TailStructureNumber value
     * @return int|null
     */
    public function getTailStructureNumber()
    {
        return $this->TailStructureNumber;
    }
    /**
     * Set TailStructureNumber value
     * @param int $tailStructureNumber
     * @return \App\Symmetry\Entities\StructType\XML_Command
     */
    public function setTailStructureNumber($tailStructureNumber = null)
    {
        // validation for constraint: int
        if (!is_null($tailStructureNumber) && !(is_int($tailStructureNumber) || ctype_digit($tailStructureNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tailStructureNumber, true), gettype($tailStructureNumber)), __LINE__);
        }
        $this->TailStructureNumber = $tailStructureNumber;
        return $this;
    }
}
