<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CardTransaction StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CardTransaction
 * @subpackage Structs
 */
class XML_CardTransaction extends AbstractStructBase
{
    /**
     * The CardHolderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardHolderID;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardNumber;
    /**
     * The CustomerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerCode;
    /**
     * The DateTimeOfTxn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeOfTxn;
    /**
     * The TimeZoneCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZoneCode;
    /**
     * Constructor method for XML_CardTransaction
     * @uses XML_CardTransaction::setCardHolderID()
     * @uses XML_CardTransaction::setCardNumber()
     * @uses XML_CardTransaction::setCustomerCode()
     * @uses XML_CardTransaction::setDateTimeOfTxn()
     * @uses XML_CardTransaction::setTimeZoneCode()
     * @param int $cardHolderID
     * @param int $cardNumber
     * @param int $customerCode
     * @param string $dateTimeOfTxn
     * @param string $timeZoneCode
     */
    public function __construct($cardHolderID = null, $cardNumber = null, $customerCode = null, $dateTimeOfTxn = null, $timeZoneCode = null)
    {
        $this
            ->setCardHolderID($cardHolderID)
            ->setCardNumber($cardNumber)
            ->setCustomerCode($customerCode)
            ->setDateTimeOfTxn($dateTimeOfTxn)
            ->setTimeZoneCode($timeZoneCode);
    }
    /**
     * Get CardHolderID value
     * @return int|null
     */
    public function getCardHolderID()
    {
        return $this->CardHolderID;
    }
    /**
     * Set CardHolderID value
     * @param int $cardHolderID
     * @return \App\Symmetry\Entities\StructType\XML_CardTransaction
     */
    public function setCardHolderID($cardHolderID = null)
    {
        // validation for constraint: int
        if (!is_null($cardHolderID) && !(is_int($cardHolderID) || ctype_digit($cardHolderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardHolderID, true), gettype($cardHolderID)), __LINE__);
        }
        $this->CardHolderID = $cardHolderID;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return int|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param int $cardNumber
     * @return \App\Symmetry\Entities\StructType\XML_CardTransaction
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($cardNumber) && !(is_int($cardNumber) || ctype_digit($cardNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CustomerCode value
     * @return int|null
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }
    /**
     * Set CustomerCode value
     * @param int $customerCode
     * @return \App\Symmetry\Entities\StructType\XML_CardTransaction
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: int
        if (!is_null($customerCode) && !(is_int($customerCode) || ctype_digit($customerCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerCode, true), gettype($customerCode)), __LINE__);
        }
        $this->CustomerCode = $customerCode;
        return $this;
    }
    /**
     * Get DateTimeOfTxn value
     * @return string|null
     */
    public function getDateTimeOfTxn()
    {
        return $this->DateTimeOfTxn;
    }
    /**
     * Set DateTimeOfTxn value
     * @param string $dateTimeOfTxn
     * @return \App\Symmetry\Entities\StructType\XML_CardTransaction
     */
    public function setDateTimeOfTxn($dateTimeOfTxn = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeOfTxn) && !is_string($dateTimeOfTxn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeOfTxn, true), gettype($dateTimeOfTxn)), __LINE__);
        }
        $this->DateTimeOfTxn = $dateTimeOfTxn;
        return $this;
    }
    /**
     * Get TimeZoneCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZoneCode()
    {
        return isset($this->TimeZoneCode) ? $this->TimeZoneCode : null;
    }
    /**
     * Set TimeZoneCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZoneCode
     * @return \App\Symmetry\Entities\StructType\XML_CardTransaction
     */
    public function setTimeZoneCode($timeZoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneCode) && !is_string($timeZoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneCode, true), gettype($timeZoneCode)), __LINE__);
        }
        if (is_null($timeZoneCode) || (is_array($timeZoneCode) && empty($timeZoneCode))) {
            unset($this->TimeZoneCode);
        } else {
            $this->TimeZoneCode = $timeZoneCode;
        }
        return $this;
    }
}
