<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CardReader StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CardReader
 * @subpackage Structs
 */
class XML_CardReader extends AbstractStructBase
{
    /**
     * The AccessID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessID;
    /**
     * The ActiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActiveDate;
    /**
     * The CardID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardID;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The InactiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InactiveDate;
    /**
     * The ReaderDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReaderDescription;
    /**
     * The ReaderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderID;
    /**
     * The TimeCodeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeCodeDescription;
    /**
     * The TimeCodeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TimeCodeID;
    /**
     * The Valid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Valid;
    /**
     * Constructor method for XML_CardReader
     * @uses XML_CardReader::setAccessID()
     * @uses XML_CardReader::setActiveDate()
     * @uses XML_CardReader::setCardID()
     * @uses XML_CardReader::setCompanyID()
     * @uses XML_CardReader::setEnabled()
     * @uses XML_CardReader::setInactiveDate()
     * @uses XML_CardReader::setReaderDescription()
     * @uses XML_CardReader::setReaderID()
     * @uses XML_CardReader::setTimeCodeDescription()
     * @uses XML_CardReader::setTimeCodeID()
     * @uses XML_CardReader::setValid()
     * @param int $accessID
     * @param string $activeDate
     * @param int $cardID
     * @param int $companyID
     * @param bool $enabled
     * @param string $inactiveDate
     * @param string $readerDescription
     * @param int $readerID
     * @param string $timeCodeDescription
     * @param int $timeCodeID
     * @param bool $valid
     */
    public function __construct($accessID = null, $activeDate = null, $cardID = null, $companyID = null, $enabled = null, $inactiveDate = null, $readerDescription = null, $readerID = null, $timeCodeDescription = null, $timeCodeID = null, $valid = null)
    {
        $this
            ->setAccessID($accessID)
            ->setActiveDate($activeDate)
            ->setCardID($cardID)
            ->setCompanyID($companyID)
            ->setEnabled($enabled)
            ->setInactiveDate($inactiveDate)
            ->setReaderDescription($readerDescription)
            ->setReaderID($readerID)
            ->setTimeCodeDescription($timeCodeDescription)
            ->setTimeCodeID($timeCodeID)
            ->setValid($valid);
    }
    /**
     * Get AccessID value
     * @return int|null
     */
    public function getAccessID()
    {
        return $this->AccessID;
    }
    /**
     * Set AccessID value
     * @param int $accessID
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setAccessID($accessID = null)
    {
        // validation for constraint: int
        if (!is_null($accessID) && !(is_int($accessID) || ctype_digit($accessID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessID, true), gettype($accessID)), __LINE__);
        }
        $this->AccessID = $accessID;
        return $this;
    }
    /**
     * Get ActiveDate value
     * @return string|null
     */
    public function getActiveDate()
    {
        return $this->ActiveDate;
    }
    /**
     * Set ActiveDate value
     * @param string $activeDate
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setActiveDate($activeDate = null)
    {
        // validation for constraint: string
        if (!is_null($activeDate) && !is_string($activeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeDate, true), gettype($activeDate)), __LINE__);
        }
        $this->ActiveDate = $activeDate;
        return $this;
    }
    /**
     * Get CardID value
     * @return int|null
     */
    public function getCardID()
    {
        return $this->CardID;
    }
    /**
     * Set CardID value
     * @param int $cardID
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setCardID($cardID = null)
    {
        // validation for constraint: int
        if (!is_null($cardID) && !(is_int($cardID) || ctype_digit($cardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardID, true), gettype($cardID)), __LINE__);
        }
        $this->CardID = $cardID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get InactiveDate value
     * @return string|null
     */
    public function getInactiveDate()
    {
        return $this->InactiveDate;
    }
    /**
     * Set InactiveDate value
     * @param string $inactiveDate
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setInactiveDate($inactiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($inactiveDate) && !is_string($inactiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inactiveDate, true), gettype($inactiveDate)), __LINE__);
        }
        $this->InactiveDate = $inactiveDate;
        return $this;
    }
    /**
     * Get ReaderDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReaderDescription()
    {
        return isset($this->ReaderDescription) ? $this->ReaderDescription : null;
    }
    /**
     * Set ReaderDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $readerDescription
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setReaderDescription($readerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($readerDescription) && !is_string($readerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readerDescription, true), gettype($readerDescription)), __LINE__);
        }
        if (is_null($readerDescription) || (is_array($readerDescription) && empty($readerDescription))) {
            unset($this->ReaderDescription);
        } else {
            $this->ReaderDescription = $readerDescription;
        }
        return $this;
    }
    /**
     * Get ReaderID value
     * @return int|null
     */
    public function getReaderID()
    {
        return $this->ReaderID;
    }
    /**
     * Set ReaderID value
     * @param int $readerID
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setReaderID($readerID = null)
    {
        // validation for constraint: int
        if (!is_null($readerID) && !(is_int($readerID) || ctype_digit($readerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerID, true), gettype($readerID)), __LINE__);
        }
        $this->ReaderID = $readerID;
        return $this;
    }
    /**
     * Get TimeCodeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeCodeDescription()
    {
        return isset($this->TimeCodeDescription) ? $this->TimeCodeDescription : null;
    }
    /**
     * Set TimeCodeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeCodeDescription
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setTimeCodeDescription($timeCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($timeCodeDescription) && !is_string($timeCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeCodeDescription, true), gettype($timeCodeDescription)), __LINE__);
        }
        if (is_null($timeCodeDescription) || (is_array($timeCodeDescription) && empty($timeCodeDescription))) {
            unset($this->TimeCodeDescription);
        } else {
            $this->TimeCodeDescription = $timeCodeDescription;
        }
        return $this;
    }
    /**
     * Get TimeCodeID value
     * @return int|null
     */
    public function getTimeCodeID()
    {
        return $this->TimeCodeID;
    }
    /**
     * Set TimeCodeID value
     * @param int $timeCodeID
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setTimeCodeID($timeCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($timeCodeID) && !(is_int($timeCodeID) || ctype_digit($timeCodeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeCodeID, true), gettype($timeCodeID)), __LINE__);
        }
        $this->TimeCodeID = $timeCodeID;
        return $this;
    }
    /**
     * Get Valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->Valid;
    }
    /**
     * Set Valid value
     * @param bool $valid
     * @return \App\Symmetry\Entities\StructType\XML_CardReader
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valid, true), gettype($valid)), __LINE__);
        }
        $this->Valid = $valid;
        return $this;
    }
}
