<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CardIntrusionArea StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CardIntrusionArea
 * @subpackage Structs
 */
class XML_CardIntrusionArea extends AbstractStructBase
{
    /**
     * The AccessID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessID;
    /**
     * The ActiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActiveDate;
    /**
     * The AreaDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaDescription;
    /**
     * The AreaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AreaID;
    /**
     * The CardID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardID;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The InactiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InactiveDate;
    /**
     * The Valid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Valid;
    /**
     * Constructor method for XML_CardIntrusionArea
     * @uses XML_CardIntrusionArea::setAccessID()
     * @uses XML_CardIntrusionArea::setActiveDate()
     * @uses XML_CardIntrusionArea::setAreaDescription()
     * @uses XML_CardIntrusionArea::setAreaID()
     * @uses XML_CardIntrusionArea::setCardID()
     * @uses XML_CardIntrusionArea::setCompanyID()
     * @uses XML_CardIntrusionArea::setEnabled()
     * @uses XML_CardIntrusionArea::setInactiveDate()
     * @uses XML_CardIntrusionArea::setValid()
     * @param int $accessID
     * @param string $activeDate
     * @param string $areaDescription
     * @param int $areaID
     * @param int $cardID
     * @param int $companyID
     * @param bool $enabled
     * @param string $inactiveDate
     * @param bool $valid
     */
    public function __construct($accessID = null, $activeDate = null, $areaDescription = null, $areaID = null, $cardID = null, $companyID = null, $enabled = null, $inactiveDate = null, $valid = null)
    {
        $this
            ->setAccessID($accessID)
            ->setActiveDate($activeDate)
            ->setAreaDescription($areaDescription)
            ->setAreaID($areaID)
            ->setCardID($cardID)
            ->setCompanyID($companyID)
            ->setEnabled($enabled)
            ->setInactiveDate($inactiveDate)
            ->setValid($valid);
    }
    /**
     * Get AccessID value
     * @return int|null
     */
    public function getAccessID()
    {
        return $this->AccessID;
    }
    /**
     * Set AccessID value
     * @param int $accessID
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setAccessID($accessID = null)
    {
        // validation for constraint: int
        if (!is_null($accessID) && !(is_int($accessID) || ctype_digit($accessID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessID, true), gettype($accessID)), __LINE__);
        }
        $this->AccessID = $accessID;
        return $this;
    }
    /**
     * Get ActiveDate value
     * @return string|null
     */
    public function getActiveDate()
    {
        return $this->ActiveDate;
    }
    /**
     * Set ActiveDate value
     * @param string $activeDate
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setActiveDate($activeDate = null)
    {
        // validation for constraint: string
        if (!is_null($activeDate) && !is_string($activeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeDate, true), gettype($activeDate)), __LINE__);
        }
        $this->ActiveDate = $activeDate;
        return $this;
    }
    /**
     * Get AreaDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaDescription()
    {
        return isset($this->AreaDescription) ? $this->AreaDescription : null;
    }
    /**
     * Set AreaDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaDescription
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setAreaDescription($areaDescription = null)
    {
        // validation for constraint: string
        if (!is_null($areaDescription) && !is_string($areaDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaDescription, true), gettype($areaDescription)), __LINE__);
        }
        if (is_null($areaDescription) || (is_array($areaDescription) && empty($areaDescription))) {
            unset($this->AreaDescription);
        } else {
            $this->AreaDescription = $areaDescription;
        }
        return $this;
    }
    /**
     * Get AreaID value
     * @return int|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param int $areaID
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: int
        if (!is_null($areaID) && !(is_int($areaID) || ctype_digit($areaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get CardID value
     * @return int|null
     */
    public function getCardID()
    {
        return $this->CardID;
    }
    /**
     * Set CardID value
     * @param int $cardID
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setCardID($cardID = null)
    {
        // validation for constraint: int
        if (!is_null($cardID) && !(is_int($cardID) || ctype_digit($cardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardID, true), gettype($cardID)), __LINE__);
        }
        $this->CardID = $cardID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get InactiveDate value
     * @return string|null
     */
    public function getInactiveDate()
    {
        return $this->InactiveDate;
    }
    /**
     * Set InactiveDate value
     * @param string $inactiveDate
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setInactiveDate($inactiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($inactiveDate) && !is_string($inactiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inactiveDate, true), gettype($inactiveDate)), __LINE__);
        }
        $this->InactiveDate = $inactiveDate;
        return $this;
    }
    /**
     * Get Valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->Valid;
    }
    /**
     * Set Valid value
     * @param bool $valid
     * @return \App\Symmetry\Entities\StructType\XML_CardIntrusionArea
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valid, true), gettype($valid)), __LINE__);
        }
        $this->Valid = $valid;
        return $this;
    }
}
