<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CardHolderRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CardHolderRequest
 * @subpackage Structs
 */
class XML_CardHolderRequest extends Pagination
{
    /**
     * The ActiveDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActiveDateTime;
    /**
     * The Arguments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfstring
     */
    public $Arguments;
    /**
     * The InactiveDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InactiveDateTime;
    /**
     * The IncludeCardAccessRights
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeCardAccessRights;
    /**
     * The IncludeCardData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeCardData;
    /**
     * The IncludeImageData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeImageData;
    /**
     * The IncludePersonalData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePersonalData;
    /**
     * The SearchCardStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchCardStatus;
    /**
     * The SearchMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchMethod;
    /**
     * The SearchOperand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchOperand;
    /**
     * Constructor method for XML_CardHolderRequest
     * @uses XML_CardHolderRequest::setActiveDateTime()
     * @uses XML_CardHolderRequest::setArguments()
     * @uses XML_CardHolderRequest::setInactiveDateTime()
     * @uses XML_CardHolderRequest::setIncludeCardAccessRights()
     * @uses XML_CardHolderRequest::setIncludeCardData()
     * @uses XML_CardHolderRequest::setIncludeImageData()
     * @uses XML_CardHolderRequest::setIncludePersonalData()
     * @uses XML_CardHolderRequest::setSearchCardStatus()
     * @uses XML_CardHolderRequest::setSearchMethod()
     * @uses XML_CardHolderRequest::setSearchOperand()
     * @param string $activeDateTime
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfstring $arguments
     * @param string $inactiveDateTime
     * @param bool $includeCardAccessRights
     * @param bool $includeCardData
     * @param bool $includeImageData
     * @param bool $includePersonalData
     * @param string $searchCardStatus
     * @param string $searchMethod
     * @param string $searchOperand
     */
    public function __construct($activeDateTime = null, \App\Symmetry\Entities\ArrayType\ArrayOfstring $arguments = null, $inactiveDateTime = null, $includeCardAccessRights = null, $includeCardData = null, $includeImageData = null, $includePersonalData = null, $searchCardStatus = null, $searchMethod = null, $searchOperand = null)
    {
        $this
            ->setActiveDateTime($activeDateTime)
            ->setArguments($arguments)
            ->setInactiveDateTime($inactiveDateTime)
            ->setIncludeCardAccessRights($includeCardAccessRights)
            ->setIncludeCardData($includeCardData)
            ->setIncludeImageData($includeImageData)
            ->setIncludePersonalData($includePersonalData)
            ->setSearchCardStatus($searchCardStatus)
            ->setSearchMethod($searchMethod)
            ->setSearchOperand($searchOperand);
    }
    /**
     * Get ActiveDateTime value
     * @return string|null
     */
    public function getActiveDateTime()
    {
        return $this->ActiveDateTime;
    }
    /**
     * Set ActiveDateTime value
     * @param string $activeDateTime
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setActiveDateTime($activeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($activeDateTime) && !is_string($activeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeDateTime, true), gettype($activeDateTime)), __LINE__);
        }
        $this->ActiveDateTime = $activeDateTime;
        return $this;
    }
    /**
     * Get Arguments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfstring|null
     */
    public function getArguments()
    {
        return isset($this->Arguments) ? $this->Arguments : null;
    }
    /**
     * Set Arguments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfstring $arguments
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setArguments(\App\Symmetry\Entities\ArrayType\ArrayOfstring $arguments = null)
    {
        if (is_null($arguments) || (is_array($arguments) && empty($arguments))) {
            unset($this->Arguments);
        } else {
            $this->Arguments = $arguments;
        }
        return $this;
    }
    /**
     * Get InactiveDateTime value
     * @return string|null
     */
    public function getInactiveDateTime()
    {
        return $this->InactiveDateTime;
    }
    /**
     * Set InactiveDateTime value
     * @param string $inactiveDateTime
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setInactiveDateTime($inactiveDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($inactiveDateTime) && !is_string($inactiveDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inactiveDateTime, true), gettype($inactiveDateTime)), __LINE__);
        }
        $this->InactiveDateTime = $inactiveDateTime;
        return $this;
    }
    /**
     * Get IncludeCardAccessRights value
     * @return bool|null
     */
    public function getIncludeCardAccessRights()
    {
        return $this->IncludeCardAccessRights;
    }
    /**
     * Set IncludeCardAccessRights value
     * @param bool $includeCardAccessRights
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setIncludeCardAccessRights($includeCardAccessRights = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCardAccessRights) && !is_bool($includeCardAccessRights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCardAccessRights, true), gettype($includeCardAccessRights)), __LINE__);
        }
        $this->IncludeCardAccessRights = $includeCardAccessRights;
        return $this;
    }
    /**
     * Get IncludeCardData value
     * @return bool|null
     */
    public function getIncludeCardData()
    {
        return $this->IncludeCardData;
    }
    /**
     * Set IncludeCardData value
     * @param bool $includeCardData
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setIncludeCardData($includeCardData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCardData) && !is_bool($includeCardData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCardData, true), gettype($includeCardData)), __LINE__);
        }
        $this->IncludeCardData = $includeCardData;
        return $this;
    }
    /**
     * Get IncludeImageData value
     * @return bool|null
     */
    public function getIncludeImageData()
    {
        return $this->IncludeImageData;
    }
    /**
     * Set IncludeImageData value
     * @param bool $includeImageData
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setIncludeImageData($includeImageData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeImageData) && !is_bool($includeImageData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeImageData, true), gettype($includeImageData)), __LINE__);
        }
        $this->IncludeImageData = $includeImageData;
        return $this;
    }
    /**
     * Get IncludePersonalData value
     * @return bool|null
     */
    public function getIncludePersonalData()
    {
        return $this->IncludePersonalData;
    }
    /**
     * Set IncludePersonalData value
     * @param bool $includePersonalData
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setIncludePersonalData($includePersonalData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePersonalData) && !is_bool($includePersonalData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePersonalData, true), gettype($includePersonalData)), __LINE__);
        }
        $this->IncludePersonalData = $includePersonalData;
        return $this;
    }
    /**
     * Get SearchCardStatus value
     * @return string|null
     */
    public function getSearchCardStatus()
    {
        return $this->SearchCardStatus;
    }
    /**
     * Set SearchCardStatus value
     * @uses \App\Symmetry\Entities\EnumType\EnSearchCardStatus::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnSearchCardStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchCardStatus
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setSearchCardStatus($searchCardStatus = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnSearchCardStatus::valueIsValid($searchCardStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnSearchCardStatus', is_array($searchCardStatus) ? implode(', ', $searchCardStatus) : var_export($searchCardStatus, true), implode(', ', \App\Symmetry\Entities\EnumType\EnSearchCardStatus::getValidValues())), __LINE__);
        }
        $this->SearchCardStatus = $searchCardStatus;
        return $this;
    }
    /**
     * Get SearchMethod value
     * @return string|null
     */
    public function getSearchMethod()
    {
        return $this->SearchMethod;
    }
    /**
     * Set SearchMethod value
     * @uses \App\Symmetry\Entities\EnumType\EnSearchMethod::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnSearchMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchMethod
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setSearchMethod($searchMethod = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnSearchMethod::valueIsValid($searchMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnSearchMethod', is_array($searchMethod) ? implode(', ', $searchMethod) : var_export($searchMethod, true), implode(', ', \App\Symmetry\Entities\EnumType\EnSearchMethod::getValidValues())), __LINE__);
        }
        $this->SearchMethod = $searchMethod;
        return $this;
    }
    /**
     * Get SearchOperand value
     * @return string|null
     */
    public function getSearchOperand()
    {
        return $this->SearchOperand;
    }
    /**
     * Set SearchOperand value
     * @uses \App\Symmetry\Entities\EnumType\EnSearchMethod::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnSearchMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchOperand
     * @return \App\Symmetry\Entities\StructType\XML_CardHolderRequest
     */
    public function setSearchOperand($searchOperand = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnSearchMethod::valueIsValid($searchOperand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnSearchMethod', is_array($searchOperand) ? implode(', ', $searchOperand) : var_export($searchOperand, true), implode(', ', \App\Symmetry\Entities\EnumType\EnSearchMethod::getValidValues())), __LINE__);
        }
        $this->SearchOperand = $searchOperand;
        return $this;
    }
}
