<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CardAccessGroup StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CardAccessGroup
 * @subpackage Structs
 */
class XML_CardAccessGroup extends AbstractStructBase
{
    /**
     * The AccessGroupDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessGroupDescription;
    /**
     * The AccessGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessGroupID;
    /**
     * The AccessID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessID;
    /**
     * The ActiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActiveDate;
    /**
     * The CardID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardID;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The InactiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InactiveDate;
    /**
     * The ReaderGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup
     */
    public $ReaderGroups;
    /**
     * The Readers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader
     */
    public $Readers;
    /**
     * The Valid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Valid;
    /**
     * Constructor method for XML_CardAccessGroup
     * @uses XML_CardAccessGroup::setAccessGroupDescription()
     * @uses XML_CardAccessGroup::setAccessGroupID()
     * @uses XML_CardAccessGroup::setAccessID()
     * @uses XML_CardAccessGroup::setActiveDate()
     * @uses XML_CardAccessGroup::setCardID()
     * @uses XML_CardAccessGroup::setCompanyID()
     * @uses XML_CardAccessGroup::setEnabled()
     * @uses XML_CardAccessGroup::setInactiveDate()
     * @uses XML_CardAccessGroup::setReaderGroups()
     * @uses XML_CardAccessGroup::setReaders()
     * @uses XML_CardAccessGroup::setValid()
     * @param string $accessGroupDescription
     * @param int $accessGroupID
     * @param int $accessID
     * @param string $activeDate
     * @param int $cardID
     * @param int $companyID
     * @param bool $enabled
     * @param string $inactiveDate
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup $readerGroups
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader $readers
     * @param bool $valid
     */
    public function __construct($accessGroupDescription = null, $accessGroupID = null, $accessID = null, $activeDate = null, $cardID = null, $companyID = null, $enabled = null, $inactiveDate = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup $readerGroups = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader $readers = null, $valid = null)
    {
        $this
            ->setAccessGroupDescription($accessGroupDescription)
            ->setAccessGroupID($accessGroupID)
            ->setAccessID($accessID)
            ->setActiveDate($activeDate)
            ->setCardID($cardID)
            ->setCompanyID($companyID)
            ->setEnabled($enabled)
            ->setInactiveDate($inactiveDate)
            ->setReaderGroups($readerGroups)
            ->setReaders($readers)
            ->setValid($valid);
    }
    /**
     * Get AccessGroupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessGroupDescription()
    {
        return isset($this->AccessGroupDescription) ? $this->AccessGroupDescription : null;
    }
    /**
     * Set AccessGroupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessGroupDescription
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setAccessGroupDescription($accessGroupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($accessGroupDescription) && !is_string($accessGroupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessGroupDescription, true), gettype($accessGroupDescription)), __LINE__);
        }
        if (is_null($accessGroupDescription) || (is_array($accessGroupDescription) && empty($accessGroupDescription))) {
            unset($this->AccessGroupDescription);
        } else {
            $this->AccessGroupDescription = $accessGroupDescription;
        }
        return $this;
    }
    /**
     * Get AccessGroupID value
     * @return int|null
     */
    public function getAccessGroupID()
    {
        return $this->AccessGroupID;
    }
    /**
     * Set AccessGroupID value
     * @param int $accessGroupID
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setAccessGroupID($accessGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($accessGroupID) && !(is_int($accessGroupID) || ctype_digit($accessGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessGroupID, true), gettype($accessGroupID)), __LINE__);
        }
        $this->AccessGroupID = $accessGroupID;
        return $this;
    }
    /**
     * Get AccessID value
     * @return int|null
     */
    public function getAccessID()
    {
        return $this->AccessID;
    }
    /**
     * Set AccessID value
     * @param int $accessID
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setAccessID($accessID = null)
    {
        // validation for constraint: int
        if (!is_null($accessID) && !(is_int($accessID) || ctype_digit($accessID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessID, true), gettype($accessID)), __LINE__);
        }
        $this->AccessID = $accessID;
        return $this;
    }
    /**
     * Get ActiveDate value
     * @return string|null
     */
    public function getActiveDate()
    {
        return $this->ActiveDate;
    }
    /**
     * Set ActiveDate value
     * @param string $activeDate
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setActiveDate($activeDate = null)
    {
        // validation for constraint: string
        if (!is_null($activeDate) && !is_string($activeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeDate, true), gettype($activeDate)), __LINE__);
        }
        $this->ActiveDate = $activeDate;
        return $this;
    }
    /**
     * Get CardID value
     * @return int|null
     */
    public function getCardID()
    {
        return $this->CardID;
    }
    /**
     * Set CardID value
     * @param int $cardID
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setCardID($cardID = null)
    {
        // validation for constraint: int
        if (!is_null($cardID) && !(is_int($cardID) || ctype_digit($cardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardID, true), gettype($cardID)), __LINE__);
        }
        $this->CardID = $cardID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get InactiveDate value
     * @return string|null
     */
    public function getInactiveDate()
    {
        return $this->InactiveDate;
    }
    /**
     * Set InactiveDate value
     * @param string $inactiveDate
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setInactiveDate($inactiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($inactiveDate) && !is_string($inactiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inactiveDate, true), gettype($inactiveDate)), __LINE__);
        }
        $this->InactiveDate = $inactiveDate;
        return $this;
    }
    /**
     * Get ReaderGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup|null
     */
    public function getReaderGroups()
    {
        return isset($this->ReaderGroups) ? $this->ReaderGroups : null;
    }
    /**
     * Set ReaderGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup $readerGroups
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setReaderGroups(\App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup $readerGroups = null)
    {
        if (is_null($readerGroups) || (is_array($readerGroups) && empty($readerGroups))) {
            unset($this->ReaderGroups);
        } else {
            $this->ReaderGroups = $readerGroups;
        }
        return $this;
    }
    /**
     * Get Readers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader|null
     */
    public function getReaders()
    {
        return isset($this->Readers) ? $this->Readers : null;
    }
    /**
     * Set Readers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader $readers
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setReaders(\App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader $readers = null)
    {
        if (is_null($readers) || (is_array($readers) && empty($readers))) {
            unset($this->Readers);
        } else {
            $this->Readers = $readers;
        }
        return $this;
    }
    /**
     * Get Valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->Valid;
    }
    /**
     * Set Valid value
     * @param bool $valid
     * @return \App\Symmetry\Entities\StructType\XML_CardAccessGroup
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valid, true), gettype($valid)), __LINE__);
        }
        $this->Valid = $valid;
        return $this;
    }
}
