<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_AlarmClearRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_AlarmClearRequest
 * @subpackage Structs
 */
class XML_AlarmClearRequest extends AbstractStructBase
{
    /**
     * The AlarmAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlarmAction;
    /**
     * The AlarmID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AlarmID;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * Constructor method for XML_AlarmClearRequest
     * @uses XML_AlarmClearRequest::setAlarmAction()
     * @uses XML_AlarmClearRequest::setAlarmID()
     * @uses XML_AlarmClearRequest::setMessage()
     * @param string $alarmAction
     * @param int $alarmID
     * @param string $message
     */
    public function __construct($alarmAction = null, $alarmID = null, $message = null)
    {
        $this
            ->setAlarmAction($alarmAction)
            ->setAlarmID($alarmID)
            ->setMessage($message);
    }
    /**
     * Get AlarmAction value
     * @return string|null
     */
    public function getAlarmAction()
    {
        return $this->AlarmAction;
    }
    /**
     * Set AlarmAction value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmAction::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmAction
     * @return \App\Symmetry\Entities\StructType\XML_AlarmClearRequest
     */
    public function setAlarmAction($alarmAction = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmAction::valueIsValid($alarmAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmAction', is_array($alarmAction) ? implode(', ', $alarmAction) : var_export($alarmAction, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmAction::getValidValues())), __LINE__);
        }
        $this->AlarmAction = $alarmAction;
        return $this;
    }
    /**
     * Get AlarmID value
     * @return int|null
     */
    public function getAlarmID()
    {
        return $this->AlarmID;
    }
    /**
     * Set AlarmID value
     * @param int $alarmID
     * @return \App\Symmetry\Entities\StructType\XML_AlarmClearRequest
     */
    public function setAlarmID($alarmID = null)
    {
        // validation for constraint: int
        if (!is_null($alarmID) && !(is_int($alarmID) || ctype_digit($alarmID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmID, true), gettype($alarmID)), __LINE__);
        }
        $this->AlarmID = $alarmID;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \App\Symmetry\Entities\StructType\XML_AlarmClearRequest
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
}
