<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_AlarmActivityCategory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_AlarmActivityCategory
 * @subpackage Structs
 */
class XML_AlarmActivityCategory extends AbstractStructBase
{
    /**
     * The ActivityID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActivityID;
    /**
     * The AlarmActivityDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlarmActivityDescription;
    /**
     * The AllowReporting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowReporting;
    /**
     * The ReportbyDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReportbyDefault;
    /**
     * Constructor method for XML_AlarmActivityCategory
     * @uses XML_AlarmActivityCategory::setActivityID()
     * @uses XML_AlarmActivityCategory::setAlarmActivityDescription()
     * @uses XML_AlarmActivityCategory::setAllowReporting()
     * @uses XML_AlarmActivityCategory::setReportbyDefault()
     * @param string $activityID
     * @param string $alarmActivityDescription
     * @param bool $allowReporting
     * @param bool $reportbyDefault
     */
    public function __construct($activityID = null, $alarmActivityDescription = null, $allowReporting = null, $reportbyDefault = null)
    {
        $this
            ->setActivityID($activityID)
            ->setAlarmActivityDescription($alarmActivityDescription)
            ->setAllowReporting($allowReporting)
            ->setReportbyDefault($reportbyDefault);
    }
    /**
     * Get ActivityID value
     * @return string|null
     */
    public function getActivityID()
    {
        return $this->ActivityID;
    }
    /**
     * Set ActivityID value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityID
     * @return \App\Symmetry\Entities\StructType\XML_AlarmActivityCategory
     */
    public function setActivityID($activityID = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::valueIsValid($activityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory', is_array($activityID) ? implode(', ', $activityID) : var_export($activityID, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::getValidValues())), __LINE__);
        }
        $this->ActivityID = $activityID;
        return $this;
    }
    /**
     * Get AlarmActivityDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlarmActivityDescription()
    {
        return isset($this->AlarmActivityDescription) ? $this->AlarmActivityDescription : null;
    }
    /**
     * Set AlarmActivityDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alarmActivityDescription
     * @return \App\Symmetry\Entities\StructType\XML_AlarmActivityCategory
     */
    public function setAlarmActivityDescription($alarmActivityDescription = null)
    {
        // validation for constraint: string
        if (!is_null($alarmActivityDescription) && !is_string($alarmActivityDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alarmActivityDescription, true), gettype($alarmActivityDescription)), __LINE__);
        }
        if (is_null($alarmActivityDescription) || (is_array($alarmActivityDescription) && empty($alarmActivityDescription))) {
            unset($this->AlarmActivityDescription);
        } else {
            $this->AlarmActivityDescription = $alarmActivityDescription;
        }
        return $this;
    }
    /**
     * Get AllowReporting value
     * @return bool|null
     */
    public function getAllowReporting()
    {
        return $this->AllowReporting;
    }
    /**
     * Set AllowReporting value
     * @param bool $allowReporting
     * @return \App\Symmetry\Entities\StructType\XML_AlarmActivityCategory
     */
    public function setAllowReporting($allowReporting = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowReporting) && !is_bool($allowReporting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowReporting, true), gettype($allowReporting)), __LINE__);
        }
        $this->AllowReporting = $allowReporting;
        return $this;
    }
    /**
     * Get ReportbyDefault value
     * @return bool|null
     */
    public function getReportbyDefault()
    {
        return $this->ReportbyDefault;
    }
    /**
     * Set ReportbyDefault value
     * @param bool $reportbyDefault
     * @return \App\Symmetry\Entities\StructType\XML_AlarmActivityCategory
     */
    public function setReportbyDefault($reportbyDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($reportbyDefault) && !is_bool($reportbyDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reportbyDefault, true), gettype($reportbyDefault)), __LINE__);
        }
        $this->ReportbyDefault = $reportbyDefault;
        return $this;
    }
}
