<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_ActivityRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_ActivityRequest
 * @subpackage Structs
 */
class XML_ActivityRequest extends Pagination
{
    /**
     * The ActivitySearchMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActivitySearchMethod;
    /**
     * The SearchActivityAlarmEventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchActivityAlarmEventType;
    /**
     * The SearchActivityCardHolderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SearchActivityCardHolderID;
    /**
     * The SearchActivityCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SearchActivityCardNumber;
    /**
     * The SearchActivityClearedStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchActivityClearedStatus;
    /**
     * The SearchActivityCustomerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SearchActivityCustomerCode;
    /**
     * The SearchActivityDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchActivityDateTime;
    /**
     * The SearchActivityDeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchActivityDeviceType;
    /**
     * The SearchActivityFromDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchActivityFromDateTime;
    /**
     * The SearchActivityFromTxnID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SearchActivityFromTxnID;
    /**
     * The SearchActivityText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchActivityText;
    /**
     * The SearchActivityToDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchActivityToDateTime;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SortOrder;
    /**
     * Constructor method for XML_ActivityRequest
     * @uses XML_ActivityRequest::setActivitySearchMethod()
     * @uses XML_ActivityRequest::setSearchActivityAlarmEventType()
     * @uses XML_ActivityRequest::setSearchActivityCardHolderID()
     * @uses XML_ActivityRequest::setSearchActivityCardNumber()
     * @uses XML_ActivityRequest::setSearchActivityClearedStatus()
     * @uses XML_ActivityRequest::setSearchActivityCustomerCode()
     * @uses XML_ActivityRequest::setSearchActivityDateTime()
     * @uses XML_ActivityRequest::setSearchActivityDeviceType()
     * @uses XML_ActivityRequest::setSearchActivityFromDateTime()
     * @uses XML_ActivityRequest::setSearchActivityFromTxnID()
     * @uses XML_ActivityRequest::setSearchActivityText()
     * @uses XML_ActivityRequest::setSearchActivityToDateTime()
     * @uses XML_ActivityRequest::setSortOrder()
     * @param string $activitySearchMethod
     * @param string $searchActivityAlarmEventType
     * @param int $searchActivityCardHolderID
     * @param int $searchActivityCardNumber
     * @param string $searchActivityClearedStatus
     * @param int $searchActivityCustomerCode
     * @param string $searchActivityDateTime
     * @param string $searchActivityDeviceType
     * @param string $searchActivityFromDateTime
     * @param int $searchActivityFromTxnID
     * @param string $searchActivityText
     * @param string $searchActivityToDateTime
     * @param string $sortOrder
     */
    public function __construct($activitySearchMethod = null, $searchActivityAlarmEventType = null, $searchActivityCardHolderID = null, $searchActivityCardNumber = null, $searchActivityClearedStatus = null, $searchActivityCustomerCode = null, $searchActivityDateTime = null, $searchActivityDeviceType = null, $searchActivityFromDateTime = null, $searchActivityFromTxnID = null, $searchActivityText = null, $searchActivityToDateTime = null, $sortOrder = null)
    {
        $this
            ->setActivitySearchMethod($activitySearchMethod)
            ->setSearchActivityAlarmEventType($searchActivityAlarmEventType)
            ->setSearchActivityCardHolderID($searchActivityCardHolderID)
            ->setSearchActivityCardNumber($searchActivityCardNumber)
            ->setSearchActivityClearedStatus($searchActivityClearedStatus)
            ->setSearchActivityCustomerCode($searchActivityCustomerCode)
            ->setSearchActivityDateTime($searchActivityDateTime)
            ->setSearchActivityDeviceType($searchActivityDeviceType)
            ->setSearchActivityFromDateTime($searchActivityFromDateTime)
            ->setSearchActivityFromTxnID($searchActivityFromTxnID)
            ->setSearchActivityText($searchActivityText)
            ->setSearchActivityToDateTime($searchActivityToDateTime)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get ActivitySearchMethod value
     * @return string|null
     */
    public function getActivitySearchMethod()
    {
        return $this->ActivitySearchMethod;
    }
    /**
     * Set ActivitySearchMethod value
     * @uses \App\Symmetry\Entities\EnumType\EnActivitySearchMethod::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnActivitySearchMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activitySearchMethod
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setActivitySearchMethod($activitySearchMethod = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnActivitySearchMethod::valueIsValid($activitySearchMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnActivitySearchMethod', is_array($activitySearchMethod) ? implode(', ', $activitySearchMethod) : var_export($activitySearchMethod, true), implode(', ', \App\Symmetry\Entities\EnumType\EnActivitySearchMethod::getValidValues())), __LINE__);
        }
        $this->ActivitySearchMethod = $activitySearchMethod;
        return $this;
    }
    /**
     * Get SearchActivityAlarmEventType value
     * @return string|null
     */
    public function getSearchActivityAlarmEventType()
    {
        return $this->SearchActivityAlarmEventType;
    }
    /**
     * Set SearchActivityAlarmEventType value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmEventType::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchActivityAlarmEventType
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityAlarmEventType($searchActivityAlarmEventType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmEventType::valueIsValid($searchActivityAlarmEventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmEventType', is_array($searchActivityAlarmEventType) ? implode(', ', $searchActivityAlarmEventType) : var_export($searchActivityAlarmEventType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmEventType::getValidValues())), __LINE__);
        }
        $this->SearchActivityAlarmEventType = $searchActivityAlarmEventType;
        return $this;
    }
    /**
     * Get SearchActivityCardHolderID value
     * @return int|null
     */
    public function getSearchActivityCardHolderID()
    {
        return $this->SearchActivityCardHolderID;
    }
    /**
     * Set SearchActivityCardHolderID value
     * @param int $searchActivityCardHolderID
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityCardHolderID($searchActivityCardHolderID = null)
    {
        // validation for constraint: int
        if (!is_null($searchActivityCardHolderID) && !(is_int($searchActivityCardHolderID) || ctype_digit($searchActivityCardHolderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchActivityCardHolderID, true), gettype($searchActivityCardHolderID)), __LINE__);
        }
        $this->SearchActivityCardHolderID = $searchActivityCardHolderID;
        return $this;
    }
    /**
     * Get SearchActivityCardNumber value
     * @return int|null
     */
    public function getSearchActivityCardNumber()
    {
        return $this->SearchActivityCardNumber;
    }
    /**
     * Set SearchActivityCardNumber value
     * @param int $searchActivityCardNumber
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityCardNumber($searchActivityCardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($searchActivityCardNumber) && !(is_int($searchActivityCardNumber) || ctype_digit($searchActivityCardNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchActivityCardNumber, true), gettype($searchActivityCardNumber)), __LINE__);
        }
        $this->SearchActivityCardNumber = $searchActivityCardNumber;
        return $this;
    }
    /**
     * Get SearchActivityClearedStatus value
     * @return string|null
     */
    public function getSearchActivityClearedStatus()
    {
        return $this->SearchActivityClearedStatus;
    }
    /**
     * Set SearchActivityClearedStatus value
     * @uses \App\Symmetry\Entities\EnumType\EnClearedFlagStatus::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnClearedFlagStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchActivityClearedStatus
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityClearedStatus($searchActivityClearedStatus = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnClearedFlagStatus::valueIsValid($searchActivityClearedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnClearedFlagStatus', is_array($searchActivityClearedStatus) ? implode(', ', $searchActivityClearedStatus) : var_export($searchActivityClearedStatus, true), implode(', ', \App\Symmetry\Entities\EnumType\EnClearedFlagStatus::getValidValues())), __LINE__);
        }
        $this->SearchActivityClearedStatus = $searchActivityClearedStatus;
        return $this;
    }
    /**
     * Get SearchActivityCustomerCode value
     * @return int|null
     */
    public function getSearchActivityCustomerCode()
    {
        return $this->SearchActivityCustomerCode;
    }
    /**
     * Set SearchActivityCustomerCode value
     * @param int $searchActivityCustomerCode
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityCustomerCode($searchActivityCustomerCode = null)
    {
        // validation for constraint: int
        if (!is_null($searchActivityCustomerCode) && !(is_int($searchActivityCustomerCode) || ctype_digit($searchActivityCustomerCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchActivityCustomerCode, true), gettype($searchActivityCustomerCode)), __LINE__);
        }
        $this->SearchActivityCustomerCode = $searchActivityCustomerCode;
        return $this;
    }
    /**
     * Get SearchActivityDateTime value
     * @return string|null
     */
    public function getSearchActivityDateTime()
    {
        return $this->SearchActivityDateTime;
    }
    /**
     * Set SearchActivityDateTime value
     * @param string $searchActivityDateTime
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityDateTime($searchActivityDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($searchActivityDateTime) && !is_string($searchActivityDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchActivityDateTime, true), gettype($searchActivityDateTime)), __LINE__);
        }
        $this->SearchActivityDateTime = $searchActivityDateTime;
        return $this;
    }
    /**
     * Get SearchActivityDeviceType value
     * @return string|null
     */
    public function getSearchActivityDeviceType()
    {
        return $this->SearchActivityDeviceType;
    }
    /**
     * Set SearchActivityDeviceType value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchActivityDeviceType
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityDeviceType($searchActivityDeviceType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($searchActivityDeviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($searchActivityDeviceType) ? implode(', ', $searchActivityDeviceType) : var_export($searchActivityDeviceType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->SearchActivityDeviceType = $searchActivityDeviceType;
        return $this;
    }
    /**
     * Get SearchActivityFromDateTime value
     * @return string|null
     */
    public function getSearchActivityFromDateTime()
    {
        return $this->SearchActivityFromDateTime;
    }
    /**
     * Set SearchActivityFromDateTime value
     * @param string $searchActivityFromDateTime
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityFromDateTime($searchActivityFromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($searchActivityFromDateTime) && !is_string($searchActivityFromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchActivityFromDateTime, true), gettype($searchActivityFromDateTime)), __LINE__);
        }
        $this->SearchActivityFromDateTime = $searchActivityFromDateTime;
        return $this;
    }
    /**
     * Get SearchActivityFromTxnID value
     * @return int|null
     */
    public function getSearchActivityFromTxnID()
    {
        return $this->SearchActivityFromTxnID;
    }
    /**
     * Set SearchActivityFromTxnID value
     * @param int $searchActivityFromTxnID
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityFromTxnID($searchActivityFromTxnID = null)
    {
        // validation for constraint: int
        if (!is_null($searchActivityFromTxnID) && !(is_int($searchActivityFromTxnID) || ctype_digit($searchActivityFromTxnID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchActivityFromTxnID, true), gettype($searchActivityFromTxnID)), __LINE__);
        }
        $this->SearchActivityFromTxnID = $searchActivityFromTxnID;
        return $this;
    }
    /**
     * Get SearchActivityText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchActivityText()
    {
        return isset($this->SearchActivityText) ? $this->SearchActivityText : null;
    }
    /**
     * Set SearchActivityText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchActivityText
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityText($searchActivityText = null)
    {
        // validation for constraint: string
        if (!is_null($searchActivityText) && !is_string($searchActivityText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchActivityText, true), gettype($searchActivityText)), __LINE__);
        }
        if (is_null($searchActivityText) || (is_array($searchActivityText) && empty($searchActivityText))) {
            unset($this->SearchActivityText);
        } else {
            $this->SearchActivityText = $searchActivityText;
        }
        return $this;
    }
    /**
     * Get SearchActivityToDateTime value
     * @return string|null
     */
    public function getSearchActivityToDateTime()
    {
        return $this->SearchActivityToDateTime;
    }
    /**
     * Set SearchActivityToDateTime value
     * @param string $searchActivityToDateTime
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSearchActivityToDateTime($searchActivityToDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($searchActivityToDateTime) && !is_string($searchActivityToDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchActivityToDateTime, true), gettype($searchActivityToDateTime)), __LINE__);
        }
        $this->SearchActivityToDateTime = $searchActivityToDateTime;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @uses \App\Symmetry\Entities\EnumType\EnSortOrder::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnSortOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \App\Symmetry\Entities\StructType\XML_ActivityRequest
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnSortOrder::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnSortOrder', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \App\Symmetry\Entities\EnumType\EnSortOrder::getValidValues())), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
}
