<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_Activity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_Activity
 * @subpackage Structs
 */
class XML_Activity extends AbstractStructBase
{
    /**
     * The AckDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AckDate;
    /**
     * The AckUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AckUserName;
    /**
     * The AckedFlag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AckedFlag;
    /**
     * The ActivityCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActivityCategory;
    /**
     * The AlarmEventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AlarmEventType;
    /**
     * The AlarmID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AlarmID;
    /**
     * The CardHolderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardHolderID;
    /**
     * The CardIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardIdentifier;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardNumber;
    /**
     * The CardNumberString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumberString;
    /**
     * The ChainID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChainID;
    /**
     * The ClearedFlag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ClearedFlag;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The CustomerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerCode;
    /**
     * The DeviceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceID;
    /**
     * The DeviceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceNumber;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceType;
    /**
     * The DeviceTypeEnumerated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeviceTypeEnumerated;
    /**
     * The DoorControlUnitID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DoorControlUnitID;
    /**
     * The EmployeeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmployeeNumber;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Priority;
    /**
     * The ResetFlag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResetFlag;
    /**
     * The ResponseMnemonic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResponseMnemonic;
    /**
     * The TimeZoneCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZoneCode;
    /**
     * The TxnConditionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TxnConditionName;
    /**
     * The When
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $When;
    /**
     * The Where
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Where;
    /**
     * The Who
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\StructType\Who
     */
    public $Who;
    /**
     * Constructor method for XML_Activity
     * @uses XML_Activity::setAckDate()
     * @uses XML_Activity::setAckUserName()
     * @uses XML_Activity::setAckedFlag()
     * @uses XML_Activity::setActivityCategory()
     * @uses XML_Activity::setAlarmEventType()
     * @uses XML_Activity::setAlarmID()
     * @uses XML_Activity::setCardHolderID()
     * @uses XML_Activity::setCardIdentifier()
     * @uses XML_Activity::setCardNumber()
     * @uses XML_Activity::setCardNumberString()
     * @uses XML_Activity::setChainID()
     * @uses XML_Activity::setClearedFlag()
     * @uses XML_Activity::setCompany()
     * @uses XML_Activity::setCompanyID()
     * @uses XML_Activity::setCustomerCode()
     * @uses XML_Activity::setDeviceID()
     * @uses XML_Activity::setDeviceNumber()
     * @uses XML_Activity::setDeviceType()
     * @uses XML_Activity::setDeviceTypeEnumerated()
     * @uses XML_Activity::setDoorControlUnitID()
     * @uses XML_Activity::setEmployeeNumber()
     * @uses XML_Activity::setPriority()
     * @uses XML_Activity::setResetFlag()
     * @uses XML_Activity::setResponseMnemonic()
     * @uses XML_Activity::setTimeZoneCode()
     * @uses XML_Activity::setTxnConditionName()
     * @uses XML_Activity::setWhen()
     * @uses XML_Activity::setWhere()
     * @uses XML_Activity::setWho()
     * @param string $ackDate
     * @param string $ackUserName
     * @param bool $ackedFlag
     * @param string $activityCategory
     * @param int $alarmEventType
     * @param int $alarmID
     * @param int $cardHolderID
     * @param string $cardIdentifier
     * @param int $cardNumber
     * @param string $cardNumberString
     * @param int $chainID
     * @param bool $clearedFlag
     * @param string $company
     * @param int $companyID
     * @param int $customerCode
     * @param int $deviceID
     * @param int $deviceNumber
     * @param int $deviceType
     * @param string $deviceTypeEnumerated
     * @param int $doorControlUnitID
     * @param string $employeeNumber
     * @param int $priority
     * @param bool $resetFlag
     * @param int $responseMnemonic
     * @param string $timeZoneCode
     * @param string $txnConditionName
     * @param string $when
     * @param string $where
     * @param \App\Symmetry\Entities\StructType\Who $who
     */
    public function __construct($ackDate = null, $ackUserName = null, $ackedFlag = null, $activityCategory = null, $alarmEventType = null, $alarmID = null, $cardHolderID = null, $cardIdentifier = null, $cardNumber = null, $cardNumberString = null, $chainID = null, $clearedFlag = null, $company = null, $companyID = null, $customerCode = null, $deviceID = null, $deviceNumber = null, $deviceType = null, $deviceTypeEnumerated = null, $doorControlUnitID = null, $employeeNumber = null, $priority = null, $resetFlag = null, $responseMnemonic = null, $timeZoneCode = null, $txnConditionName = null, $when = null, $where = null, \App\Symmetry\Entities\StructType\Who $who = null)
    {
        $this
            ->setAckDate($ackDate)
            ->setAckUserName($ackUserName)
            ->setAckedFlag($ackedFlag)
            ->setActivityCategory($activityCategory)
            ->setAlarmEventType($alarmEventType)
            ->setAlarmID($alarmID)
            ->setCardHolderID($cardHolderID)
            ->setCardIdentifier($cardIdentifier)
            ->setCardNumber($cardNumber)
            ->setCardNumberString($cardNumberString)
            ->setChainID($chainID)
            ->setClearedFlag($clearedFlag)
            ->setCompany($company)
            ->setCompanyID($companyID)
            ->setCustomerCode($customerCode)
            ->setDeviceID($deviceID)
            ->setDeviceNumber($deviceNumber)
            ->setDeviceType($deviceType)
            ->setDeviceTypeEnumerated($deviceTypeEnumerated)
            ->setDoorControlUnitID($doorControlUnitID)
            ->setEmployeeNumber($employeeNumber)
            ->setPriority($priority)
            ->setResetFlag($resetFlag)
            ->setResponseMnemonic($responseMnemonic)
            ->setTimeZoneCode($timeZoneCode)
            ->setTxnConditionName($txnConditionName)
            ->setWhen($when)
            ->setWhere($where)
            ->setWho($who);
    }
    /**
     * Get AckDate value
     * @return string|null
     */
    public function getAckDate()
    {
        return $this->AckDate;
    }
    /**
     * Set AckDate value
     * @param string $ackDate
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setAckDate($ackDate = null)
    {
        // validation for constraint: string
        if (!is_null($ackDate) && !is_string($ackDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ackDate, true), gettype($ackDate)), __LINE__);
        }
        $this->AckDate = $ackDate;
        return $this;
    }
    /**
     * Get AckUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAckUserName()
    {
        return isset($this->AckUserName) ? $this->AckUserName : null;
    }
    /**
     * Set AckUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ackUserName
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setAckUserName($ackUserName = null)
    {
        // validation for constraint: string
        if (!is_null($ackUserName) && !is_string($ackUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ackUserName, true), gettype($ackUserName)), __LINE__);
        }
        if (is_null($ackUserName) || (is_array($ackUserName) && empty($ackUserName))) {
            unset($this->AckUserName);
        } else {
            $this->AckUserName = $ackUserName;
        }
        return $this;
    }
    /**
     * Get AckedFlag value
     * @return bool|null
     */
    public function getAckedFlag()
    {
        return $this->AckedFlag;
    }
    /**
     * Set AckedFlag value
     * @param bool $ackedFlag
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setAckedFlag($ackedFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($ackedFlag) && !is_bool($ackedFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ackedFlag, true), gettype($ackedFlag)), __LINE__);
        }
        $this->AckedFlag = $ackedFlag;
        return $this;
    }
    /**
     * Get ActivityCategory value
     * @return string|null
     */
    public function getActivityCategory()
    {
        return $this->ActivityCategory;
    }
    /**
     * Set ActivityCategory value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityCategory
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setActivityCategory($activityCategory = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::valueIsValid($activityCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory', is_array($activityCategory) ? implode(', ', $activityCategory) : var_export($activityCategory, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::getValidValues())), __LINE__);
        }
        $this->ActivityCategory = $activityCategory;
        return $this;
    }
    /**
     * Get AlarmEventType value
     * @return int|null
     */
    public function getAlarmEventType()
    {
        return $this->AlarmEventType;
    }
    /**
     * Set AlarmEventType value
     * @param int $alarmEventType
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setAlarmEventType($alarmEventType = null)
    {
        // validation for constraint: int
        if (!is_null($alarmEventType) && !(is_int($alarmEventType) || ctype_digit($alarmEventType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmEventType, true), gettype($alarmEventType)), __LINE__);
        }
        $this->AlarmEventType = $alarmEventType;
        return $this;
    }
    /**
     * Get AlarmID value
     * @return int|null
     */
    public function getAlarmID()
    {
        return $this->AlarmID;
    }
    /**
     * Set AlarmID value
     * @param int $alarmID
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setAlarmID($alarmID = null)
    {
        // validation for constraint: int
        if (!is_null($alarmID) && !(is_int($alarmID) || ctype_digit($alarmID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmID, true), gettype($alarmID)), __LINE__);
        }
        $this->AlarmID = $alarmID;
        return $this;
    }
    /**
     * Get CardHolderID value
     * @return int|null
     */
    public function getCardHolderID()
    {
        return $this->CardHolderID;
    }
    /**
     * Set CardHolderID value
     * @param int $cardHolderID
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setCardHolderID($cardHolderID = null)
    {
        // validation for constraint: int
        if (!is_null($cardHolderID) && !(is_int($cardHolderID) || ctype_digit($cardHolderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardHolderID, true), gettype($cardHolderID)), __LINE__);
        }
        $this->CardHolderID = $cardHolderID;
        return $this;
    }
    /**
     * Get CardIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardIdentifier()
    {
        return isset($this->CardIdentifier) ? $this->CardIdentifier : null;
    }
    /**
     * Set CardIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardIdentifier
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setCardIdentifier($cardIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($cardIdentifier) && !is_string($cardIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIdentifier, true), gettype($cardIdentifier)), __LINE__);
        }
        if (is_null($cardIdentifier) || (is_array($cardIdentifier) && empty($cardIdentifier))) {
            unset($this->CardIdentifier);
        } else {
            $this->CardIdentifier = $cardIdentifier;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * @return int|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param int $cardNumber
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($cardNumber) && !(is_int($cardNumber) || ctype_digit($cardNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardNumberString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumberString()
    {
        return isset($this->CardNumberString) ? $this->CardNumberString : null;
    }
    /**
     * Set CardNumberString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumberString
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setCardNumberString($cardNumberString = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumberString) && !is_string($cardNumberString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumberString, true), gettype($cardNumberString)), __LINE__);
        }
        if (is_null($cardNumberString) || (is_array($cardNumberString) && empty($cardNumberString))) {
            unset($this->CardNumberString);
        } else {
            $this->CardNumberString = $cardNumberString;
        }
        return $this;
    }
    /**
     * Get ChainID value
     * @return int|null
     */
    public function getChainID()
    {
        return $this->ChainID;
    }
    /**
     * Set ChainID value
     * @param int $chainID
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setChainID($chainID = null)
    {
        // validation for constraint: int
        if (!is_null($chainID) && !(is_int($chainID) || ctype_digit($chainID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chainID, true), gettype($chainID)), __LINE__);
        }
        $this->ChainID = $chainID;
        return $this;
    }
    /**
     * Get ClearedFlag value
     * @return bool|null
     */
    public function getClearedFlag()
    {
        return $this->ClearedFlag;
    }
    /**
     * Set ClearedFlag value
     * @param bool $clearedFlag
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setClearedFlag($clearedFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($clearedFlag) && !is_bool($clearedFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clearedFlag, true), gettype($clearedFlag)), __LINE__);
        }
        $this->ClearedFlag = $clearedFlag;
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $company
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get CustomerCode value
     * @return int|null
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }
    /**
     * Set CustomerCode value
     * @param int $customerCode
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: int
        if (!is_null($customerCode) && !(is_int($customerCode) || ctype_digit($customerCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerCode, true), gettype($customerCode)), __LINE__);
        }
        $this->CustomerCode = $customerCode;
        return $this;
    }
    /**
     * Get DeviceID value
     * @return int|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param int $deviceID
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: int
        if (!is_null($deviceID) && !(is_int($deviceID) || ctype_digit($deviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceID, true), gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get DeviceNumber value
     * @return int|null
     */
    public function getDeviceNumber()
    {
        return $this->DeviceNumber;
    }
    /**
     * Set DeviceNumber value
     * @param int $deviceNumber
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setDeviceNumber($deviceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($deviceNumber) && !(is_int($deviceNumber) || ctype_digit($deviceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceNumber, true), gettype($deviceNumber)), __LINE__);
        }
        $this->DeviceNumber = $deviceNumber;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return int|null
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @param int $deviceType
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: int
        if (!is_null($deviceType) && !(is_int($deviceType) || ctype_digit($deviceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceType, true), gettype($deviceType)), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get DeviceTypeEnumerated value
     * @return string|null
     */
    public function getDeviceTypeEnumerated()
    {
        return $this->DeviceTypeEnumerated;
    }
    /**
     * Set DeviceTypeEnumerated value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceTypeEnumerated
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setDeviceTypeEnumerated($deviceTypeEnumerated = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($deviceTypeEnumerated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($deviceTypeEnumerated) ? implode(', ', $deviceTypeEnumerated) : var_export($deviceTypeEnumerated, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->DeviceTypeEnumerated = $deviceTypeEnumerated;
        return $this;
    }
    /**
     * Get DoorControlUnitID value
     * @return int|null
     */
    public function getDoorControlUnitID()
    {
        return $this->DoorControlUnitID;
    }
    /**
     * Set DoorControlUnitID value
     * @param int $doorControlUnitID
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setDoorControlUnitID($doorControlUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($doorControlUnitID) && !(is_int($doorControlUnitID) || ctype_digit($doorControlUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doorControlUnitID, true), gettype($doorControlUnitID)), __LINE__);
        }
        $this->DoorControlUnitID = $doorControlUnitID;
        return $this;
    }
    /**
     * Get EmployeeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmployeeNumber()
    {
        return isset($this->EmployeeNumber) ? $this->EmployeeNumber : null;
    }
    /**
     * Set EmployeeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $employeeNumber
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setEmployeeNumber($employeeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($employeeNumber) && !is_string($employeeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeNumber, true), gettype($employeeNumber)), __LINE__);
        }
        if (is_null($employeeNumber) || (is_array($employeeNumber) && empty($employeeNumber))) {
            unset($this->EmployeeNumber);
        } else {
            $this->EmployeeNumber = $employeeNumber;
        }
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get ResetFlag value
     * @return bool|null
     */
    public function getResetFlag()
    {
        return $this->ResetFlag;
    }
    /**
     * Set ResetFlag value
     * @param bool $resetFlag
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setResetFlag($resetFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($resetFlag) && !is_bool($resetFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resetFlag, true), gettype($resetFlag)), __LINE__);
        }
        $this->ResetFlag = $resetFlag;
        return $this;
    }
    /**
     * Get ResponseMnemonic value
     * @return int|null
     */
    public function getResponseMnemonic()
    {
        return $this->ResponseMnemonic;
    }
    /**
     * Set ResponseMnemonic value
     * @param int $responseMnemonic
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setResponseMnemonic($responseMnemonic = null)
    {
        // validation for constraint: int
        if (!is_null($responseMnemonic) && !(is_int($responseMnemonic) || ctype_digit($responseMnemonic))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($responseMnemonic, true), gettype($responseMnemonic)), __LINE__);
        }
        $this->ResponseMnemonic = $responseMnemonic;
        return $this;
    }
    /**
     * Get TimeZoneCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZoneCode()
    {
        return isset($this->TimeZoneCode) ? $this->TimeZoneCode : null;
    }
    /**
     * Set TimeZoneCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZoneCode
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setTimeZoneCode($timeZoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneCode) && !is_string($timeZoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneCode, true), gettype($timeZoneCode)), __LINE__);
        }
        if (is_null($timeZoneCode) || (is_array($timeZoneCode) && empty($timeZoneCode))) {
            unset($this->TimeZoneCode);
        } else {
            $this->TimeZoneCode = $timeZoneCode;
        }
        return $this;
    }
    /**
     * Get TxnConditionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTxnConditionName()
    {
        return isset($this->TxnConditionName) ? $this->TxnConditionName : null;
    }
    /**
     * Set TxnConditionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $txnConditionName
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setTxnConditionName($txnConditionName = null)
    {
        // validation for constraint: string
        if (!is_null($txnConditionName) && !is_string($txnConditionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($txnConditionName, true), gettype($txnConditionName)), __LINE__);
        }
        if (is_null($txnConditionName) || (is_array($txnConditionName) && empty($txnConditionName))) {
            unset($this->TxnConditionName);
        } else {
            $this->TxnConditionName = $txnConditionName;
        }
        return $this;
    }
    /**
     * Get When value
     * @return string|null
     */
    public function getWhen()
    {
        return $this->When;
    }
    /**
     * Set When value
     * @param string $when
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setWhen($when = null)
    {
        // validation for constraint: string
        if (!is_null($when) && !is_string($when)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($when, true), gettype($when)), __LINE__);
        }
        $this->When = $when;
        return $this;
    }
    /**
     * Get Where value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhere()
    {
        return isset($this->Where) ? $this->Where : null;
    }
    /**
     * Set Where value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $where
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setWhere($where = null)
    {
        // validation for constraint: string
        if (!is_null($where) && !is_string($where)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($where, true), gettype($where)), __LINE__);
        }
        if (is_null($where) || (is_array($where) && empty($where))) {
            unset($this->Where);
        } else {
            $this->Where = $where;
        }
        return $this;
    }
    /**
     * Get Who value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\StructType\Who|null
     */
    public function getWho()
    {
        return isset($this->Who) ? $this->Who : null;
    }
    /**
     * Set Who value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\StructType\Who $who
     * @return \App\Symmetry\Entities\StructType\XML_Activity
     */
    public function setWho(\App\Symmetry\Entities\StructType\Who $who = null)
    {
        if (is_null($who) || (is_array($who) && empty($who))) {
            unset($this->Who);
        } else {
            $this->Who = $who;
        }
        return $this;
    }
}
