<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_AccessGroup StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_AccessGroup
 * @subpackage Structs
 */
class XML_AccessGroup extends AbstractStructBase
{
    /**
     * The AccessGroupDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessGroupDescription;
    /**
     * The AccessGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessGroupID;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * Constructor method for XML_AccessGroup
     * @uses XML_AccessGroup::setAccessGroupDescription()
     * @uses XML_AccessGroup::setAccessGroupID()
     * @uses XML_AccessGroup::setCompanyID()
     * @param string $accessGroupDescription
     * @param int $accessGroupID
     * @param int $companyID
     */
    public function __construct($accessGroupDescription = null, $accessGroupID = null, $companyID = null)
    {
        $this
            ->setAccessGroupDescription($accessGroupDescription)
            ->setAccessGroupID($accessGroupID)
            ->setCompanyID($companyID);
    }
    /**
     * Get AccessGroupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessGroupDescription()
    {
        return isset($this->AccessGroupDescription) ? $this->AccessGroupDescription : null;
    }
    /**
     * Set AccessGroupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessGroupDescription
     * @return \App\Symmetry\Entities\StructType\XML_AccessGroup
     */
    public function setAccessGroupDescription($accessGroupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($accessGroupDescription) && !is_string($accessGroupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessGroupDescription, true), gettype($accessGroupDescription)), __LINE__);
        }
        if (is_null($accessGroupDescription) || (is_array($accessGroupDescription) && empty($accessGroupDescription))) {
            unset($this->AccessGroupDescription);
        } else {
            $this->AccessGroupDescription = $accessGroupDescription;
        }
        return $this;
    }
    /**
     * Get AccessGroupID value
     * @return int|null
     */
    public function getAccessGroupID()
    {
        return $this->AccessGroupID;
    }
    /**
     * Set AccessGroupID value
     * @param int $accessGroupID
     * @return \App\Symmetry\Entities\StructType\XML_AccessGroup
     */
    public function setAccessGroupID($accessGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($accessGroupID) && !(is_int($accessGroupID) || ctype_digit($accessGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessGroupID, true), gettype($accessGroupID)), __LINE__);
        }
        $this->AccessGroupID = $accessGroupID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_AccessGroup
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
}
