<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTS ServiceType
 * @subpackage Services
 */
class GTS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TSendDeviceCommand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TSendDeviceCommand $parameters
     * @return \App\Symmetry\Entities\StructType\G4TSendDeviceCommandResponse|bool
     */
    public function G4TSendDeviceCommand(\App\Symmetry\Entities\StructType\G4TSendDeviceCommand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TSendDeviceCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TSetAlarmActivityCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TSetAlarmActivityCategory $parameters
     * @return \App\Symmetry\Entities\StructType\G4TSetAlarmActivityCategoryResponse|bool
     */
    public function G4TSetAlarmActivityCategory(\App\Symmetry\Entities\StructType\G4TSetAlarmActivityCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TSetAlarmActivityCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TSendPCDoorControlAccessCommand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TSendPCDoorControlAccessCommand $parameters
     * @return \App\Symmetry\Entities\StructType\G4TSendPCDoorControlAccessCommandResponse|bool
     */
    public function G4TSendPCDoorControlAccessCommand(\App\Symmetry\Entities\StructType\G4TSendPCDoorControlAccessCommand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TSendPCDoorControlAccessCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TSetCardHoldersAntipassbackZone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackZone $parameters
     * @return \App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackZoneResponse|bool
     */
    public function G4TSetCardHoldersAntipassbackZone(\App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackZone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TSetCardHoldersAntipassbackZone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * G4TSetCardHoldersAntipassbackToNeutral
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackToNeutral $parameters
     * @return \App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackToNeutralResponse|bool
     */
    public function G4TSetCardHoldersAntipassbackToNeutral(\App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackToNeutral $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TSetCardHoldersAntipassbackToNeutral($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TSendDeviceCommandResponse|\App\Symmetry\Entities\StructType\G4TSendPCDoorControlAccessCommandResponse|\App\Symmetry\Entities\StructType\G4TSetAlarmActivityCategoryResponse|\App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackToNeutralResponse|\App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackZoneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
