<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTL ServiceType
 * @subpackage Services
 */
class GTL extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TLogin $parameters
     * @return \App\Symmetry\Entities\StructType\G4TLoginResponse|bool
     */
    public function G4TLogin(\App\Symmetry\Entities\StructType\G4TLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TLoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
