<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTG ServiceType
 * @subpackage Services
 */
class GTG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TGetSystemParameters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetSystemParameters $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetSystemParametersResponse|bool
     */
    public function G4TGetSystemParameters(\App\Symmetry\Entities\StructType\G4TGetSystemParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetSystemParameters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetImportRecordRequests
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetImportRecordRequests $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetImportRecordRequestsResponse|bool
     */
    public function G4TGetImportRecordRequests(\App\Symmetry\Entities\StructType\G4TGetImportRecordRequests $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetImportRecordRequests($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetImportCardHolderDataStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetImportCardHolderDataStatus $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetImportCardHolderDataStatusResponse|bool
     */
    public function G4TGetImportCardHolderDataStatus(\App\Symmetry\Entities\StructType\G4TGetImportCardHolderDataStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetImportCardHolderDataStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetAccessGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetAccessGroups $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetAccessGroupsResponse|bool
     */
    public function G4TGetAccessGroups(\App\Symmetry\Entities\StructType\G4TGetAccessGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetAccessGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetTimeCodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetTimeCodes $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetTimeCodesResponse|bool
     */
    public function G4TGetTimeCodes(\App\Symmetry\Entities\StructType\G4TGetTimeCodes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetTimeCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetBadgeFormats
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetBadgeFormats $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetBadgeFormatsResponse|bool
     */
    public function G4TGetBadgeFormats(\App\Symmetry\Entities\StructType\G4TGetBadgeFormats $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetBadgeFormats($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetPersonalDataTitles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetPersonalDataTitles $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetPersonalDataTitlesResponse|bool
     */
    public function G4TGetPersonalDataTitles(\App\Symmetry\Entities\StructType\G4TGetPersonalDataTitles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetPersonalDataTitles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetDeviceTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetDeviceTypes $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetDeviceTypesResponse|bool
     */
    public function G4TGetDeviceTypes(\App\Symmetry\Entities\StructType\G4TGetDeviceTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetDeviceTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetAdminTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetAdminTypes $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetAdminTypesResponse|bool
     */
    public function G4TGetAdminTypes(\App\Symmetry\Entities\StructType\G4TGetAdminTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetAdminTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetCompanies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetCompanies $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetCompaniesResponse|bool
     */
    public function G4TGetCompanies(\App\Symmetry\Entities\StructType\G4TGetCompanies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetCompanies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetCommandTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetCommandTypes $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetCommandTypesResponse|bool
     */
    public function G4TGetCommandTypes(\App\Symmetry\Entities\StructType\G4TGetCommandTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetCommandTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetOutstandingAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetOutstandingAlarms $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetOutstandingAlarmsResponse|bool
     */
    public function G4TGetOutstandingAlarms(\App\Symmetry\Entities\StructType\G4TGetOutstandingAlarms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetOutstandingAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetOutstandingAlarmsDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetOutstandingAlarmsDocument $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetOutstandingAlarmsDocumentResponse|bool
     */
    public function G4TGetOutstandingAlarmsDocument(\App\Symmetry\Entities\StructType\G4TGetOutstandingAlarmsDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetOutstandingAlarmsDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetCardHolderInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetCardHolderInformation $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetCardHolderInformationResponse|bool
     */
    public function G4TGetCardHolderInformation(\App\Symmetry\Entities\StructType\G4TGetCardHolderInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetCardHolderInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * G4TGetCardHolderInformationDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetCardHolderInformationDocument $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetCardHolderInformationDocumentResponse|bool
     */
    public function G4TGetCardHolderInformationDocument(\App\Symmetry\Entities\StructType\G4TGetCardHolderInformationDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetCardHolderInformationDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetDevices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetDevices $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetDevicesResponse|bool
     */
    public function G4TGetDevices(\App\Symmetry\Entities\StructType\G4TGetDevices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetDevices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetCommands
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetCommands $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetCommandsResponse|bool
     */
    public function G4TGetCommands(\App\Symmetry\Entities\StructType\G4TGetCommands $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetCommands($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetVersionInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetVersionInformation $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetVersionInformationResponse|bool
     */
    public function G4TGetVersionInformation(\App\Symmetry\Entities\StructType\G4TGetVersionInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetVersionInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetDeviceAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetDeviceAlarms $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetDeviceAlarmsResponse|bool
     */
    public function G4TGetDeviceAlarms(\App\Symmetry\Entities\StructType\G4TGetDeviceAlarms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetDeviceAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetDeviceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetDeviceStatus $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetDeviceStatusResponse|bool
     */
    public function G4TGetDeviceStatus(\App\Symmetry\Entities\StructType\G4TGetDeviceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetDeviceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetDoorStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetDoorStatus $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetDoorStatusResponse|bool
     */
    public function G4TGetDoorStatus(\App\Symmetry\Entities\StructType\G4TGetDoorStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetDoorStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetAlarmActivityCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetAlarmActivityCategory $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetAlarmActivityCategoryResponse|bool
     */
    public function G4TGetAlarmActivityCategory(\App\Symmetry\Entities\StructType\G4TGetAlarmActivityCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetAlarmActivityCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetActivity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetActivity $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetActivityResponse|bool
     */
    public function G4TGetActivity(\App\Symmetry\Entities\StructType\G4TGetActivity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetActivityDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetActivityDocument $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetActivityDocumentResponse|bool
     */
    public function G4TGetActivityDocument(\App\Symmetry\Entities\StructType\G4TGetActivityDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetActivityDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetLastReaderUsedForCardHolder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetLastReaderUsedForCardHolder $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetLastReaderUsedForCardHolderResponse|bool
     */
    public function G4TGetLastReaderUsedForCardHolder(\App\Symmetry\Entities\StructType\G4TGetLastReaderUsedForCardHolder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetLastReaderUsedForCardHolder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetLastReadersUsedForCardHolder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetLastReadersUsedForCardHolder $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetLastReadersUsedForCardHolderResponse|bool
     */
    public function G4TGetLastReadersUsedForCardHolder(\App\Symmetry\Entities\StructType\G4TGetLastReadersUsedForCardHolder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetLastReadersUsedForCardHolder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * G4TGetLastCardTransactionsForAReader
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReader $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReaderResponse|bool
     */
    public function G4TGetLastCardTransactionsForAReader(\App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReader $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetLastCardTransactionsForAReader($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * G4TGetLastCardTransactionsForAReaderGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReaderGroup $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReaderGroupResponse|bool
     */
    public function G4TGetLastCardTransactionsForAReaderGroup(\App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReaderGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetLastCardTransactionsForAReaderGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named G4TGetCurrentAntiPassbackZone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TGetCurrentAntiPassbackZone $parameters
     * @return \App\Symmetry\Entities\StructType\G4TGetCurrentAntiPassbackZoneResponse|bool
     */
    public function G4TGetCurrentAntiPassbackZone(\App\Symmetry\Entities\StructType\G4TGetCurrentAntiPassbackZone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TGetCurrentAntiPassbackZone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TGetAccessGroupsResponse|\App\Symmetry\Entities\StructType\G4TGetActivityDocumentResponse|\App\Symmetry\Entities\StructType\G4TGetActivityResponse|\App\Symmetry\Entities\StructType\G4TGetAdminTypesResponse|\App\Symmetry\Entities\StructType\G4TGetAlarmActivityCategoryResponse|\App\Symmetry\Entities\StructType\G4TGetBadgeFormatsResponse|\App\Symmetry\Entities\StructType\G4TGetCardHolderInformationDocumentResponse|\App\Symmetry\Entities\StructType\G4TGetCardHolderInformationResponse|\App\Symmetry\Entities\StructType\G4TGetCommandsResponse|\App\Symmetry\Entities\StructType\G4TGetCommandTypesResponse|\App\Symmetry\Entities\StructType\G4TGetCompaniesResponse|\App\Symmetry\Entities\StructType\G4TGetCurrentAntiPassbackZoneResponse|\App\Symmetry\Entities\StructType\G4TGetDeviceAlarmsResponse|\App\Symmetry\Entities\StructType\G4TGetDevicesResponse|\App\Symmetry\Entities\StructType\G4TGetDeviceStatusResponse|\App\Symmetry\Entities\StructType\G4TGetDeviceTypesResponse|\App\Symmetry\Entities\StructType\G4TGetDoorStatusResponse|\App\Symmetry\Entities\StructType\G4TGetImportCardHolderDataStatusResponse|\App\Symmetry\Entities\StructType\G4TGetImportRecordRequestsResponse|\App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReaderGroupResponse|\App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReaderResponse|\App\Symmetry\Entities\StructType\G4TGetLastReadersUsedForCardHolderResponse|\App\Symmetry\Entities\StructType\G4TGetLastReaderUsedForCardHolderResponse|\App\Symmetry\Entities\StructType\G4TGetOutstandingAlarmsDocumentResponse|\App\Symmetry\Entities\StructType\G4TGetOutstandingAlarmsResponse|\App\Symmetry\Entities\StructType\G4TGetPersonalDataTitlesResponse|\App\Symmetry\Entities\StructType\G4TGetSystemParametersResponse|\App\Symmetry\Entities\StructType\G4TGetTimeCodesResponse|\App\Symmetry\Entities\StructType\G4TGetVersionInformationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
