<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTC ServiceType
 * @subpackage Services
 */
class GTC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TClearOutstandingAlarm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TClearOutstandingAlarm $parameters
     * @return \App\Symmetry\Entities\StructType\G4TClearOutstandingAlarmResponse|bool
     */
    public function G4TClearOutstandingAlarm(\App\Symmetry\Entities\StructType\G4TClearOutstandingAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TClearOutstandingAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TClearOutstandingAlarmResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
