<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Warning StructType
 * @subpackage Structs
 */
class Warning extends AbstractStructBase
{
    /**
     * The WarningCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarningCode;
    /**
     * The WarningCodeExplenation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarningCodeExplenation;
    /**
     * The Field
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for Warning
     * @uses Warning::setWarningCode()
     * @uses Warning::setWarningCodeExplenation()
     * @uses Warning::setField()
     * @uses Warning::setValue()
     * @param string $warningCode
     * @param string $warningCodeExplenation
     * @param string $field
     * @param string $value
     */
    public function __construct($warningCode = null, $warningCodeExplenation = null, $field = null, $value = null)
    {
        $this
            ->setWarningCode($warningCode)
            ->setWarningCodeExplenation($warningCodeExplenation)
            ->setField($field)
            ->setValue($value);
    }
    /**
     * Get WarningCode value
     * @return string|null
     */
    public function getWarningCode()
    {
        return $this->WarningCode;
    }
    /**
     * Set WarningCode value
     * @param string $warningCode
     * @return \StructType\Warning
     */
    public function setWarningCode($warningCode = null)
    {
        // validation for constraint: string
        if (!is_null($warningCode) && !is_string($warningCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningCode, true), gettype($warningCode)), __LINE__);
        }
        $this->WarningCode = $warningCode;
        return $this;
    }
    /**
     * Get WarningCodeExplenation value
     * @return string|null
     */
    public function getWarningCodeExplenation()
    {
        return $this->WarningCodeExplenation;
    }
    /**
     * Set WarningCodeExplenation value
     * @param string $warningCodeExplenation
     * @return \StructType\Warning
     */
    public function setWarningCodeExplenation($warningCodeExplenation = null)
    {
        // validation for constraint: string
        if (!is_null($warningCodeExplenation) && !is_string($warningCodeExplenation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningCodeExplenation, true), gettype($warningCodeExplenation)), __LINE__);
        }
        $this->WarningCodeExplenation = $warningCodeExplenation;
        return $this;
    }
    /**
     * Get Field value
     * @return string|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @param string $field
     * @return \StructType\Warning
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field, true), gettype($field)), __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Warning
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
