<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViaRouteInsertGPX StructType
 * @subpackage Structs
 */
class ViaRouteInsertGPX extends ViaRoute_WithBehavior
{
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Radius;
    /**
     * The gpx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gpx;
    /**
     * Constructor method for ViaRouteInsertGPX
     * @uses ViaRouteInsertGPX::setRadius()
     * @uses ViaRouteInsertGPX::setGpx()
     * @param int $radius
     * @param string $gpx
     */
    public function __construct($radius = null, $gpx = null)
    {
        $this
            ->setRadius($radius)
            ->setGpx($gpx);
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\ViaRouteInsertGPX
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !(is_int($radius) || ctype_digit($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get gpx value
     * @return string|null
     */
    public function getGpx()
    {
        return $this->gpx;
    }
    /**
     * Set gpx value
     * @param string $gpx
     * @return \StructType\ViaRouteInsertGPX
     */
    public function setGpx($gpx = null)
    {
        // validation for constraint: string
        if (!is_null($gpx) && !is_string($gpx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gpx, true), gettype($gpx)), __LINE__);
        }
        $this->gpx = $gpx;
        return $this;
    }
}
