<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViaPoint StructType
 * @subpackage Structs
 */
class ViaPoint extends AbstractStructBase
{
    /**
     * The OrderSeq
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderSeq;
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Radius;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressInfo;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * Constructor method for ViaPoint
     * @uses ViaPoint::setOrderSeq()
     * @uses ViaPoint::setRadius()
     * @uses ViaPoint::setName()
     * @uses ViaPoint::setAddressInfo()
     * @uses ViaPoint::setPosition()
     * @param int $orderSeq
     * @param int $radius
     * @param string $name
     * @param string $addressInfo
     * @param \StructType\Position $position
     */
    public function __construct($orderSeq = null, $radius = null, $name = null, $addressInfo = null, \StructType\Position $position = null)
    {
        $this
            ->setOrderSeq($orderSeq)
            ->setRadius($radius)
            ->setName($name)
            ->setAddressInfo($addressInfo)
            ->setPosition($position);
    }
    /**
     * Get OrderSeq value
     * @return int
     */
    public function getOrderSeq()
    {
        return $this->OrderSeq;
    }
    /**
     * Set OrderSeq value
     * @param int $orderSeq
     * @return \StructType\ViaPoint
     */
    public function setOrderSeq($orderSeq = null)
    {
        // validation for constraint: int
        if (!is_null($orderSeq) && !(is_int($orderSeq) || ctype_digit($orderSeq))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSeq, true), gettype($orderSeq)), __LINE__);
        }
        $this->OrderSeq = $orderSeq;
        return $this;
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\ViaPoint
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !(is_int($radius) || ctype_digit($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ViaPoint
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return string|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param string $addressInfo
     * @return \StructType\ViaPoint
     */
    public function setAddressInfo($addressInfo = null)
    {
        // validation for constraint: string
        if (!is_null($addressInfo) && !is_string($addressInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressInfo, true), gettype($addressInfo)), __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\ViaPoint
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
