<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleTechnicalInfo StructType
 * @subpackage Structs
 */
class VehicleTechnicalInfo extends AbstractStructBase
{
    /**
     * The KmsCounter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $KmsCounter;
    /**
     * The ConsumptionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ConsumptionType;
    /**
     * The LicenseDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LicenseDate;
    /**
     * The PurchasePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PurchasePrice;
    /**
     * The Refrigerator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Refrigerator;
    /**
     * The RefrigeratorIndexFirstUse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RefrigeratorIndexFirstUse;
    /**
     * The FuelIndexFirstUse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelIndexFirstUse;
    /**
     * The KmsCountFirstUse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmsCountFirstUse;
    /**
     * The FuelCounter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $FuelCounter;
    /**
     * The PHNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PHNumber;
    /**
     * The TareWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TareWeight;
    /**
     * The ConstructionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ConstructionDate;
    /**
     * The Elevator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Elevator;
    /**
     * The KmsMaintenance_canbus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmsMaintenance_canbus;
    /**
     * The KmsMaintenance_user_defined
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmsMaintenance_user_defined;
    /**
     * The IndutyDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IndutyDate;
    /**
     * The OutOfDuty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OutOfDuty;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The BrandCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BrandCode;
    /**
     * The MaterialTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaterialTypeCode;
    /**
     * The LicenseDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicenseDescription;
    /**
     * The ChassisDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChassisDescription;
    /**
     * The ChassisNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChassisNumber;
    /**
     * The FuelTankCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FuelTankCode;
    /**
     * Constructor method for VehicleTechnicalInfo
     * @uses VehicleTechnicalInfo::setKmsCounter()
     * @uses VehicleTechnicalInfo::setConsumptionType()
     * @uses VehicleTechnicalInfo::setLicenseDate()
     * @uses VehicleTechnicalInfo::setPurchasePrice()
     * @uses VehicleTechnicalInfo::setRefrigerator()
     * @uses VehicleTechnicalInfo::setRefrigeratorIndexFirstUse()
     * @uses VehicleTechnicalInfo::setFuelIndexFirstUse()
     * @uses VehicleTechnicalInfo::setKmsCountFirstUse()
     * @uses VehicleTechnicalInfo::setFuelCounter()
     * @uses VehicleTechnicalInfo::setPHNumber()
     * @uses VehicleTechnicalInfo::setTareWeight()
     * @uses VehicleTechnicalInfo::setConstructionDate()
     * @uses VehicleTechnicalInfo::setElevator()
     * @uses VehicleTechnicalInfo::setKmsMaintenance_canbus()
     * @uses VehicleTechnicalInfo::setKmsMaintenance_user_defined()
     * @uses VehicleTechnicalInfo::setIndutyDate()
     * @uses VehicleTechnicalInfo::setOutOfDuty()
     * @uses VehicleTechnicalInfo::setDescription()
     * @uses VehicleTechnicalInfo::setBrandCode()
     * @uses VehicleTechnicalInfo::setMaterialTypeCode()
     * @uses VehicleTechnicalInfo::setLicenseDescription()
     * @uses VehicleTechnicalInfo::setChassisDescription()
     * @uses VehicleTechnicalInfo::setChassisNumber()
     * @uses VehicleTechnicalInfo::setFuelTankCode()
     * @param bool $kmsCounter
     * @param string $consumptionType
     * @param string $licenseDate
     * @param int $purchasePrice
     * @param bool $refrigerator
     * @param int $refrigeratorIndexFirstUse
     * @param int $fuelIndexFirstUse
     * @param int $kmsCountFirstUse
     * @param bool $fuelCounter
     * @param float $pHNumber
     * @param int $tareWeight
     * @param string $constructionDate
     * @param bool $elevator
     * @param int $kmsMaintenance_canbus
     * @param int $kmsMaintenance_user_defined
     * @param string $indutyDate
     * @param string $outOfDuty
     * @param string $description
     * @param string $brandCode
     * @param string $materialTypeCode
     * @param string $licenseDescription
     * @param string $chassisDescription
     * @param string $chassisNumber
     * @param string $fuelTankCode
     */
    public function __construct($kmsCounter = null, $consumptionType = null, $licenseDate = null, $purchasePrice = null, $refrigerator = null, $refrigeratorIndexFirstUse = null, $fuelIndexFirstUse = null, $kmsCountFirstUse = null, $fuelCounter = null, $pHNumber = null, $tareWeight = null, $constructionDate = null, $elevator = null, $kmsMaintenance_canbus = null, $kmsMaintenance_user_defined = null, $indutyDate = null, $outOfDuty = null, $description = null, $brandCode = null, $materialTypeCode = null, $licenseDescription = null, $chassisDescription = null, $chassisNumber = null, $fuelTankCode = null)
    {
        $this
            ->setKmsCounter($kmsCounter)
            ->setConsumptionType($consumptionType)
            ->setLicenseDate($licenseDate)
            ->setPurchasePrice($purchasePrice)
            ->setRefrigerator($refrigerator)
            ->setRefrigeratorIndexFirstUse($refrigeratorIndexFirstUse)
            ->setFuelIndexFirstUse($fuelIndexFirstUse)
            ->setKmsCountFirstUse($kmsCountFirstUse)
            ->setFuelCounter($fuelCounter)
            ->setPHNumber($pHNumber)
            ->setTareWeight($tareWeight)
            ->setConstructionDate($constructionDate)
            ->setElevator($elevator)
            ->setKmsMaintenance_canbus($kmsMaintenance_canbus)
            ->setKmsMaintenance_user_defined($kmsMaintenance_user_defined)
            ->setIndutyDate($indutyDate)
            ->setOutOfDuty($outOfDuty)
            ->setDescription($description)
            ->setBrandCode($brandCode)
            ->setMaterialTypeCode($materialTypeCode)
            ->setLicenseDescription($licenseDescription)
            ->setChassisDescription($chassisDescription)
            ->setChassisNumber($chassisNumber)
            ->setFuelTankCode($fuelTankCode);
    }
    /**
     * Get KmsCounter value
     * @return bool
     */
    public function getKmsCounter()
    {
        return $this->KmsCounter;
    }
    /**
     * Set KmsCounter value
     * @param bool $kmsCounter
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setKmsCounter($kmsCounter = null)
    {
        // validation for constraint: boolean
        if (!is_null($kmsCounter) && !is_bool($kmsCounter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kmsCounter, true), gettype($kmsCounter)), __LINE__);
        }
        $this->KmsCounter = $kmsCounter;
        return $this;
    }
    /**
     * Get ConsumptionType value
     * @return string
     */
    public function getConsumptionType()
    {
        return $this->ConsumptionType;
    }
    /**
     * Set ConsumptionType value
     * @uses \EnumType\ConsumptionType::valueIsValid()
     * @uses \EnumType\ConsumptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $consumptionType
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setConsumptionType($consumptionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConsumptionType::valueIsValid($consumptionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConsumptionType', is_array($consumptionType) ? implode(', ', $consumptionType) : var_export($consumptionType, true), implode(', ', \EnumType\ConsumptionType::getValidValues())), __LINE__);
        }
        $this->ConsumptionType = $consumptionType;
        return $this;
    }
    /**
     * Get LicenseDate value
     * @return string
     */
    public function getLicenseDate()
    {
        return $this->LicenseDate;
    }
    /**
     * Set LicenseDate value
     * @param string $licenseDate
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setLicenseDate($licenseDate = null)
    {
        // validation for constraint: string
        if (!is_null($licenseDate) && !is_string($licenseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseDate, true), gettype($licenseDate)), __LINE__);
        }
        $this->LicenseDate = $licenseDate;
        return $this;
    }
    /**
     * Get PurchasePrice value
     * @return int
     */
    public function getPurchasePrice()
    {
        return $this->PurchasePrice;
    }
    /**
     * Set PurchasePrice value
     * @param int $purchasePrice
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setPurchasePrice($purchasePrice = null)
    {
        // validation for constraint: int
        if (!is_null($purchasePrice) && !(is_int($purchasePrice) || ctype_digit($purchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($purchasePrice, true), gettype($purchasePrice)), __LINE__);
        }
        $this->PurchasePrice = $purchasePrice;
        return $this;
    }
    /**
     * Get Refrigerator value
     * @return bool
     */
    public function getRefrigerator()
    {
        return $this->Refrigerator;
    }
    /**
     * Set Refrigerator value
     * @param bool $refrigerator
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setRefrigerator($refrigerator = null)
    {
        // validation for constraint: boolean
        if (!is_null($refrigerator) && !is_bool($refrigerator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refrigerator, true), gettype($refrigerator)), __LINE__);
        }
        $this->Refrigerator = $refrigerator;
        return $this;
    }
    /**
     * Get RefrigeratorIndexFirstUse value
     * @return int
     */
    public function getRefrigeratorIndexFirstUse()
    {
        return $this->RefrigeratorIndexFirstUse;
    }
    /**
     * Set RefrigeratorIndexFirstUse value
     * @param int $refrigeratorIndexFirstUse
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setRefrigeratorIndexFirstUse($refrigeratorIndexFirstUse = null)
    {
        // validation for constraint: int
        if (!is_null($refrigeratorIndexFirstUse) && !(is_int($refrigeratorIndexFirstUse) || ctype_digit($refrigeratorIndexFirstUse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refrigeratorIndexFirstUse, true), gettype($refrigeratorIndexFirstUse)), __LINE__);
        }
        $this->RefrigeratorIndexFirstUse = $refrigeratorIndexFirstUse;
        return $this;
    }
    /**
     * Get FuelIndexFirstUse value
     * @return int
     */
    public function getFuelIndexFirstUse()
    {
        return $this->FuelIndexFirstUse;
    }
    /**
     * Set FuelIndexFirstUse value
     * @param int $fuelIndexFirstUse
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setFuelIndexFirstUse($fuelIndexFirstUse = null)
    {
        // validation for constraint: int
        if (!is_null($fuelIndexFirstUse) && !(is_int($fuelIndexFirstUse) || ctype_digit($fuelIndexFirstUse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelIndexFirstUse, true), gettype($fuelIndexFirstUse)), __LINE__);
        }
        $this->FuelIndexFirstUse = $fuelIndexFirstUse;
        return $this;
    }
    /**
     * Get KmsCountFirstUse value
     * @return int
     */
    public function getKmsCountFirstUse()
    {
        return $this->KmsCountFirstUse;
    }
    /**
     * Set KmsCountFirstUse value
     * @param int $kmsCountFirstUse
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setKmsCountFirstUse($kmsCountFirstUse = null)
    {
        // validation for constraint: int
        if (!is_null($kmsCountFirstUse) && !(is_int($kmsCountFirstUse) || ctype_digit($kmsCountFirstUse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmsCountFirstUse, true), gettype($kmsCountFirstUse)), __LINE__);
        }
        $this->KmsCountFirstUse = $kmsCountFirstUse;
        return $this;
    }
    /**
     * Get FuelCounter value
     * @return bool
     */
    public function getFuelCounter()
    {
        return $this->FuelCounter;
    }
    /**
     * Set FuelCounter value
     * @param bool $fuelCounter
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setFuelCounter($fuelCounter = null)
    {
        // validation for constraint: boolean
        if (!is_null($fuelCounter) && !is_bool($fuelCounter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fuelCounter, true), gettype($fuelCounter)), __LINE__);
        }
        $this->FuelCounter = $fuelCounter;
        return $this;
    }
    /**
     * Get PHNumber value
     * @return float
     */
    public function getPHNumber()
    {
        return $this->PHNumber;
    }
    /**
     * Set PHNumber value
     * @param float $pHNumber
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setPHNumber($pHNumber = null)
    {
        // validation for constraint: float
        if (!is_null($pHNumber) && !(is_float($pHNumber) || is_numeric($pHNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pHNumber, true), gettype($pHNumber)), __LINE__);
        }
        $this->PHNumber = $pHNumber;
        return $this;
    }
    /**
     * Get TareWeight value
     * @return int
     */
    public function getTareWeight()
    {
        return $this->TareWeight;
    }
    /**
     * Set TareWeight value
     * @param int $tareWeight
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setTareWeight($tareWeight = null)
    {
        // validation for constraint: int
        if (!is_null($tareWeight) && !(is_int($tareWeight) || ctype_digit($tareWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tareWeight, true), gettype($tareWeight)), __LINE__);
        }
        $this->TareWeight = $tareWeight;
        return $this;
    }
    /**
     * Get ConstructionDate value
     * @return string
     */
    public function getConstructionDate()
    {
        return $this->ConstructionDate;
    }
    /**
     * Set ConstructionDate value
     * @param string $constructionDate
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setConstructionDate($constructionDate = null)
    {
        // validation for constraint: string
        if (!is_null($constructionDate) && !is_string($constructionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($constructionDate, true), gettype($constructionDate)), __LINE__);
        }
        $this->ConstructionDate = $constructionDate;
        return $this;
    }
    /**
     * Get Elevator value
     * @return bool
     */
    public function getElevator()
    {
        return $this->Elevator;
    }
    /**
     * Set Elevator value
     * @param bool $elevator
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setElevator($elevator = null)
    {
        // validation for constraint: boolean
        if (!is_null($elevator) && !is_bool($elevator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($elevator, true), gettype($elevator)), __LINE__);
        }
        $this->Elevator = $elevator;
        return $this;
    }
    /**
     * Get KmsMaintenance_canbus value
     * @return int
     */
    public function getKmsMaintenance_canbus()
    {
        return $this->KmsMaintenance_canbus;
    }
    /**
     * Set KmsMaintenance_canbus value
     * @param int $kmsMaintenance_canbus
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setKmsMaintenance_canbus($kmsMaintenance_canbus = null)
    {
        // validation for constraint: int
        if (!is_null($kmsMaintenance_canbus) && !(is_int($kmsMaintenance_canbus) || ctype_digit($kmsMaintenance_canbus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmsMaintenance_canbus, true), gettype($kmsMaintenance_canbus)), __LINE__);
        }
        $this->KmsMaintenance_canbus = $kmsMaintenance_canbus;
        return $this;
    }
    /**
     * Get KmsMaintenance_user_defined value
     * @return int
     */
    public function getKmsMaintenance_user_defined()
    {
        return $this->KmsMaintenance_user_defined;
    }
    /**
     * Set KmsMaintenance_user_defined value
     * @param int $kmsMaintenance_user_defined
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setKmsMaintenance_user_defined($kmsMaintenance_user_defined = null)
    {
        // validation for constraint: int
        if (!is_null($kmsMaintenance_user_defined) && !(is_int($kmsMaintenance_user_defined) || ctype_digit($kmsMaintenance_user_defined))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmsMaintenance_user_defined, true), gettype($kmsMaintenance_user_defined)), __LINE__);
        }
        $this->KmsMaintenance_user_defined = $kmsMaintenance_user_defined;
        return $this;
    }
    /**
     * Get IndutyDate value
     * @return string
     */
    public function getIndutyDate()
    {
        return $this->IndutyDate;
    }
    /**
     * Set IndutyDate value
     * @param string $indutyDate
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setIndutyDate($indutyDate = null)
    {
        // validation for constraint: string
        if (!is_null($indutyDate) && !is_string($indutyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indutyDate, true), gettype($indutyDate)), __LINE__);
        }
        $this->IndutyDate = $indutyDate;
        return $this;
    }
    /**
     * Get OutOfDuty value
     * @return string
     */
    public function getOutOfDuty()
    {
        return $this->OutOfDuty;
    }
    /**
     * Set OutOfDuty value
     * @param string $outOfDuty
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setOutOfDuty($outOfDuty = null)
    {
        // validation for constraint: string
        if (!is_null($outOfDuty) && !is_string($outOfDuty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outOfDuty, true), gettype($outOfDuty)), __LINE__);
        }
        $this->OutOfDuty = $outOfDuty;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get MaterialTypeCode value
     * @return string|null
     */
    public function getMaterialTypeCode()
    {
        return $this->MaterialTypeCode;
    }
    /**
     * Set MaterialTypeCode value
     * @param string $materialTypeCode
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setMaterialTypeCode($materialTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($materialTypeCode) && !is_string($materialTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($materialTypeCode, true), gettype($materialTypeCode)), __LINE__);
        }
        $this->MaterialTypeCode = $materialTypeCode;
        return $this;
    }
    /**
     * Get LicenseDescription value
     * @return string|null
     */
    public function getLicenseDescription()
    {
        return $this->LicenseDescription;
    }
    /**
     * Set LicenseDescription value
     * @param string $licenseDescription
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setLicenseDescription($licenseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($licenseDescription) && !is_string($licenseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseDescription, true), gettype($licenseDescription)), __LINE__);
        }
        $this->LicenseDescription = $licenseDescription;
        return $this;
    }
    /**
     * Get ChassisDescription value
     * @return string|null
     */
    public function getChassisDescription()
    {
        return $this->ChassisDescription;
    }
    /**
     * Set ChassisDescription value
     * @param string $chassisDescription
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setChassisDescription($chassisDescription = null)
    {
        // validation for constraint: string
        if (!is_null($chassisDescription) && !is_string($chassisDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chassisDescription, true), gettype($chassisDescription)), __LINE__);
        }
        $this->ChassisDescription = $chassisDescription;
        return $this;
    }
    /**
     * Get ChassisNumber value
     * @return string|null
     */
    public function getChassisNumber()
    {
        return $this->ChassisNumber;
    }
    /**
     * Set ChassisNumber value
     * @param string $chassisNumber
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setChassisNumber($chassisNumber = null)
    {
        // validation for constraint: string
        if (!is_null($chassisNumber) && !is_string($chassisNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chassisNumber, true), gettype($chassisNumber)), __LINE__);
        }
        $this->ChassisNumber = $chassisNumber;
        return $this;
    }
    /**
     * Get FuelTankCode value
     * @return string|null
     */
    public function getFuelTankCode()
    {
        return $this->FuelTankCode;
    }
    /**
     * Set FuelTankCode value
     * @param string $fuelTankCode
     * @return \StructType\VehicleTechnicalInfo
     */
    public function setFuelTankCode($fuelTankCode = null)
    {
        // validation for constraint: string
        if (!is_null($fuelTankCode) && !is_string($fuelTankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fuelTankCode, true), gettype($fuelTankCode)), __LINE__);
        }
        $this->FuelTankCode = $fuelTankCode;
        return $this;
    }
}
