<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleStatusResult StructType
 * @subpackage Structs
 */
class VehicleStatusResult extends AbstractStructBase
{
    /**
     * The VehicleTransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VehicleTransicsID;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Mileage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Mileage;
    /**
     * The FuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FuelLevel;
    /**
     * The TotalFuelUsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalFuelUsed;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Speed;
    /**
     * The VehicleCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleCode;
    /**
     * The VehicleExternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleExternalCode;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The UpdateDatesList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUpdateDatesItem
     */
    public $UpdateDatesList;
    /**
     * The TrailerVin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrailerVin;
    /**
     * The DriverTachoCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverTachoCard;
    /**
     * The CoDriverTachoCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoDriverTachoCard;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleActivity
     */
    public $Activity;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * Constructor method for VehicleStatusResult
     * @uses VehicleStatusResult::setVehicleTransicsID()
     * @uses VehicleStatusResult::setIsActive()
     * @uses VehicleStatusResult::setMileage()
     * @uses VehicleStatusResult::setFuelLevel()
     * @uses VehicleStatusResult::setTotalFuelUsed()
     * @uses VehicleStatusResult::setSpeed()
     * @uses VehicleStatusResult::setVehicleCode()
     * @uses VehicleStatusResult::setVehicleExternalCode()
     * @uses VehicleStatusResult::setLicensePlate()
     * @uses VehicleStatusResult::setUpdateDatesList()
     * @uses VehicleStatusResult::setTrailerVin()
     * @uses VehicleStatusResult::setDriverTachoCard()
     * @uses VehicleStatusResult::setCoDriverTachoCard()
     * @uses VehicleStatusResult::setActivity()
     * @uses VehicleStatusResult::setPosition()
     * @param int $vehicleTransicsID
     * @param bool $isActive
     * @param int $mileage
     * @param int $fuelLevel
     * @param int $totalFuelUsed
     * @param string $speed
     * @param string $vehicleCode
     * @param string $vehicleExternalCode
     * @param string $licensePlate
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @param string $trailerVin
     * @param string $driverTachoCard
     * @param string $coDriverTachoCard
     * @param \StructType\VehicleActivity $activity
     * @param \StructType\PositionResult $position
     */
    public function __construct($vehicleTransicsID = null, $isActive = null, $mileage = null, $fuelLevel = null, $totalFuelUsed = null, $speed = null, $vehicleCode = null, $vehicleExternalCode = null, $licensePlate = null, \ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null, $trailerVin = null, $driverTachoCard = null, $coDriverTachoCard = null, \StructType\VehicleActivity $activity = null, \StructType\PositionResult $position = null)
    {
        $this
            ->setVehicleTransicsID($vehicleTransicsID)
            ->setIsActive($isActive)
            ->setMileage($mileage)
            ->setFuelLevel($fuelLevel)
            ->setTotalFuelUsed($totalFuelUsed)
            ->setSpeed($speed)
            ->setVehicleCode($vehicleCode)
            ->setVehicleExternalCode($vehicleExternalCode)
            ->setLicensePlate($licensePlate)
            ->setUpdateDatesList($updateDatesList)
            ->setTrailerVin($trailerVin)
            ->setDriverTachoCard($driverTachoCard)
            ->setCoDriverTachoCard($coDriverTachoCard)
            ->setActivity($activity)
            ->setPosition($position);
    }
    /**
     * Get VehicleTransicsID value
     * @return int
     */
    public function getVehicleTransicsID()
    {
        return $this->VehicleTransicsID;
    }
    /**
     * Set VehicleTransicsID value
     * @param int $vehicleTransicsID
     * @return \StructType\VehicleStatusResult
     */
    public function setVehicleTransicsID($vehicleTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleTransicsID) && !(is_int($vehicleTransicsID) || ctype_digit($vehicleTransicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleTransicsID, true), gettype($vehicleTransicsID)), __LINE__);
        }
        $this->VehicleTransicsID = $vehicleTransicsID;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\VehicleStatusResult
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Mileage value
     * @return int
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param int $mileage
     * @return \StructType\VehicleStatusResult
     */
    public function setMileage($mileage = null)
    {
        // validation for constraint: int
        if (!is_null($mileage) && !(is_int($mileage) || ctype_digit($mileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mileage, true), gettype($mileage)), __LINE__);
        }
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\VehicleStatusResult
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !(is_int($fuelLevel) || ctype_digit($fuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevel, true), gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get TotalFuelUsed value
     * @return int
     */
    public function getTotalFuelUsed()
    {
        return $this->TotalFuelUsed;
    }
    /**
     * Set TotalFuelUsed value
     * @param int $totalFuelUsed
     * @return \StructType\VehicleStatusResult
     */
    public function setTotalFuelUsed($totalFuelUsed = null)
    {
        // validation for constraint: int
        if (!is_null($totalFuelUsed) && !(is_int($totalFuelUsed) || ctype_digit($totalFuelUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalFuelUsed, true), gettype($totalFuelUsed)), __LINE__);
        }
        $this->TotalFuelUsed = $totalFuelUsed;
        return $this;
    }
    /**
     * Get Speed value
     * @return string
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param string $speed
     * @return \StructType\VehicleStatusResult
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: string
        if (!is_null($speed) && !is_string($speed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get VehicleCode value
     * @return string|null
     */
    public function getVehicleCode()
    {
        return $this->VehicleCode;
    }
    /**
     * Set VehicleCode value
     * @param string $vehicleCode
     * @return \StructType\VehicleStatusResult
     */
    public function setVehicleCode($vehicleCode = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleCode) && !is_string($vehicleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleCode, true), gettype($vehicleCode)), __LINE__);
        }
        $this->VehicleCode = $vehicleCode;
        return $this;
    }
    /**
     * Get VehicleExternalCode value
     * @return string|null
     */
    public function getVehicleExternalCode()
    {
        return $this->VehicleExternalCode;
    }
    /**
     * Set VehicleExternalCode value
     * @param string $vehicleExternalCode
     * @return \StructType\VehicleStatusResult
     */
    public function setVehicleExternalCode($vehicleExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleExternalCode) && !is_string($vehicleExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleExternalCode, true), gettype($vehicleExternalCode)), __LINE__);
        }
        $this->VehicleExternalCode = $vehicleExternalCode;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\VehicleStatusResult
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get UpdateDatesList value
     * @return \ArrayType\ArrayOfUpdateDatesItem|null
     */
    public function getUpdateDatesList()
    {
        return $this->UpdateDatesList;
    }
    /**
     * Set UpdateDatesList value
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @return \StructType\VehicleStatusResult
     */
    public function setUpdateDatesList(\ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null)
    {
        $this->UpdateDatesList = $updateDatesList;
        return $this;
    }
    /**
     * Get TrailerVin value
     * @return string|null
     */
    public function getTrailerVin()
    {
        return $this->TrailerVin;
    }
    /**
     * Set TrailerVin value
     * @param string $trailerVin
     * @return \StructType\VehicleStatusResult
     */
    public function setTrailerVin($trailerVin = null)
    {
        // validation for constraint: string
        if (!is_null($trailerVin) && !is_string($trailerVin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailerVin, true), gettype($trailerVin)), __LINE__);
        }
        $this->TrailerVin = $trailerVin;
        return $this;
    }
    /**
     * Get DriverTachoCard value
     * @return string|null
     */
    public function getDriverTachoCard()
    {
        return $this->DriverTachoCard;
    }
    /**
     * Set DriverTachoCard value
     * @param string $driverTachoCard
     * @return \StructType\VehicleStatusResult
     */
    public function setDriverTachoCard($driverTachoCard = null)
    {
        // validation for constraint: string
        if (!is_null($driverTachoCard) && !is_string($driverTachoCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverTachoCard, true), gettype($driverTachoCard)), __LINE__);
        }
        $this->DriverTachoCard = $driverTachoCard;
        return $this;
    }
    /**
     * Get CoDriverTachoCard value
     * @return string|null
     */
    public function getCoDriverTachoCard()
    {
        return $this->CoDriverTachoCard;
    }
    /**
     * Set CoDriverTachoCard value
     * @param string $coDriverTachoCard
     * @return \StructType\VehicleStatusResult
     */
    public function setCoDriverTachoCard($coDriverTachoCard = null)
    {
        // validation for constraint: string
        if (!is_null($coDriverTachoCard) && !is_string($coDriverTachoCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coDriverTachoCard, true), gettype($coDriverTachoCard)), __LINE__);
        }
        $this->CoDriverTachoCard = $coDriverTachoCard;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\VehicleActivity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\VehicleActivity $activity
     * @return \StructType\VehicleStatusResult
     */
    public function setActivity(\StructType\VehicleActivity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\VehicleStatusResult
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
