<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleStateDiagnostics StructType
 * @subpackage Structs
 */
class VehicleStateDiagnostics extends AbstractStructBase
{
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The DateTimeStateTransition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeStateTransition;
    /**
     * The DatetimeLastStateTransition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatetimeLastStateTransition;
    /**
     * Constructor method for VehicleStateDiagnostics
     * @uses VehicleStateDiagnostics::setState()
     * @uses VehicleStateDiagnostics::setDateTimeStateTransition()
     * @uses VehicleStateDiagnostics::setDatetimeLastStateTransition()
     * @param string $state
     * @param string $dateTimeStateTransition
     * @param string $datetimeLastStateTransition
     */
    public function __construct($state = null, $dateTimeStateTransition = null, $datetimeLastStateTransition = null)
    {
        $this
            ->setState($state)
            ->setDateTimeStateTransition($dateTimeStateTransition)
            ->setDatetimeLastStateTransition($datetimeLastStateTransition);
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\VehicleStateDiagnostics
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get DateTimeStateTransition value
     * @return string|null
     */
    public function getDateTimeStateTransition()
    {
        return $this->DateTimeStateTransition;
    }
    /**
     * Set DateTimeStateTransition value
     * @param string $dateTimeStateTransition
     * @return \StructType\VehicleStateDiagnostics
     */
    public function setDateTimeStateTransition($dateTimeStateTransition = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeStateTransition) && !is_string($dateTimeStateTransition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeStateTransition, true), gettype($dateTimeStateTransition)), __LINE__);
        }
        $this->DateTimeStateTransition = $dateTimeStateTransition;
        return $this;
    }
    /**
     * Get DatetimeLastStateTransition value
     * @return string|null
     */
    public function getDatetimeLastStateTransition()
    {
        return $this->DatetimeLastStateTransition;
    }
    /**
     * Set DatetimeLastStateTransition value
     * @param string $datetimeLastStateTransition
     * @return \StructType\VehicleStateDiagnostics
     */
    public function setDatetimeLastStateTransition($datetimeLastStateTransition = null)
    {
        // validation for constraint: string
        if (!is_null($datetimeLastStateTransition) && !is_string($datetimeLastStateTransition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datetimeLastStateTransition, true), gettype($datetimeLastStateTransition)), __LINE__);
        }
        $this->DatetimeLastStateTransition = $datetimeLastStateTransition;
        return $this;
    }
}
