<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleObcInfo StructType
 * @subpackage Structs
 */
class VehicleObcInfo extends AbstractStructBase
{
    /**
     * The UpdateProgress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UpdateProgress;
    /**
     * The IBC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IBC;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeviceType;
    /**
     * The SoftwareBehaviour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareBehaviour;
    /**
     * The SoftwareVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareVersion;
    /**
     * The InstructionSetVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstructionSetVersion;
    /**
     * The Planningfeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleSoftwareInformation
     */
    public $Planningfeatures;
    /**
     * The ResponseImage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseImage;
    /**
     * The ModemChannelID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemChannelID;
    /**
     * Constructor method for VehicleObcInfo
     * @uses VehicleObcInfo::setUpdateProgress()
     * @uses VehicleObcInfo::setIBC()
     * @uses VehicleObcInfo::setDeviceType()
     * @uses VehicleObcInfo::setSoftwareBehaviour()
     * @uses VehicleObcInfo::setSoftwareVersion()
     * @uses VehicleObcInfo::setInstructionSetVersion()
     * @uses VehicleObcInfo::setPlanningfeatures()
     * @uses VehicleObcInfo::setResponseImage()
     * @uses VehicleObcInfo::setModemChannelID()
     * @param int $updateProgress
     * @param int $iBC
     * @param string $deviceType
     * @param string $softwareBehaviour
     * @param string $softwareVersion
     * @param string $instructionSetVersion
     * @param \StructType\VehicleSoftwareInformation $planningfeatures
     * @param string $responseImage
     * @param string $modemChannelID
     */
    public function __construct($updateProgress = null, $iBC = null, $deviceType = null, $softwareBehaviour = null, $softwareVersion = null, $instructionSetVersion = null, \StructType\VehicleSoftwareInformation $planningfeatures = null, $responseImage = null, $modemChannelID = null)
    {
        $this
            ->setUpdateProgress($updateProgress)
            ->setIBC($iBC)
            ->setDeviceType($deviceType)
            ->setSoftwareBehaviour($softwareBehaviour)
            ->setSoftwareVersion($softwareVersion)
            ->setInstructionSetVersion($instructionSetVersion)
            ->setPlanningfeatures($planningfeatures)
            ->setResponseImage($responseImage)
            ->setModemChannelID($modemChannelID);
    }
    /**
     * Get UpdateProgress value
     * @return int
     */
    public function getUpdateProgress()
    {
        return $this->UpdateProgress;
    }
    /**
     * Set UpdateProgress value
     * @param int $updateProgress
     * @return \StructType\VehicleObcInfo
     */
    public function setUpdateProgress($updateProgress = null)
    {
        // validation for constraint: int
        if (!is_null($updateProgress) && !(is_int($updateProgress) || ctype_digit($updateProgress))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateProgress, true), gettype($updateProgress)), __LINE__);
        }
        $this->UpdateProgress = $updateProgress;
        return $this;
    }
    /**
     * Get IBC value
     * @return int
     */
    public function getIBC()
    {
        return $this->IBC;
    }
    /**
     * Set IBC value
     * @param int $iBC
     * @return \StructType\VehicleObcInfo
     */
    public function setIBC($iBC = null)
    {
        // validation for constraint: int
        if (!is_null($iBC) && !(is_int($iBC) || ctype_digit($iBC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iBC, true), gettype($iBC)), __LINE__);
        }
        $this->IBC = $iBC;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \EnumType\EnumDeviceType::valueIsValid()
     * @uses \EnumType\EnumDeviceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \StructType\VehicleObcInfo
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumDeviceType::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumDeviceType', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \EnumType\EnumDeviceType::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get SoftwareBehaviour value
     * @return string|null
     */
    public function getSoftwareBehaviour()
    {
        return $this->SoftwareBehaviour;
    }
    /**
     * Set SoftwareBehaviour value
     * @param string $softwareBehaviour
     * @return \StructType\VehicleObcInfo
     */
    public function setSoftwareBehaviour($softwareBehaviour = null)
    {
        // validation for constraint: string
        if (!is_null($softwareBehaviour) && !is_string($softwareBehaviour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareBehaviour, true), gettype($softwareBehaviour)), __LINE__);
        }
        $this->SoftwareBehaviour = $softwareBehaviour;
        return $this;
    }
    /**
     * Get SoftwareVersion value
     * @return string|null
     */
    public function getSoftwareVersion()
    {
        return $this->SoftwareVersion;
    }
    /**
     * Set SoftwareVersion value
     * @param string $softwareVersion
     * @return \StructType\VehicleObcInfo
     */
    public function setSoftwareVersion($softwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($softwareVersion) && !is_string($softwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareVersion, true), gettype($softwareVersion)), __LINE__);
        }
        $this->SoftwareVersion = $softwareVersion;
        return $this;
    }
    /**
     * Get InstructionSetVersion value
     * @return string|null
     */
    public function getInstructionSetVersion()
    {
        return $this->InstructionSetVersion;
    }
    /**
     * Set InstructionSetVersion value
     * @param string $instructionSetVersion
     * @return \StructType\VehicleObcInfo
     */
    public function setInstructionSetVersion($instructionSetVersion = null)
    {
        // validation for constraint: string
        if (!is_null($instructionSetVersion) && !is_string($instructionSetVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructionSetVersion, true), gettype($instructionSetVersion)), __LINE__);
        }
        $this->InstructionSetVersion = $instructionSetVersion;
        return $this;
    }
    /**
     * Get Planningfeatures value
     * @return \StructType\VehicleSoftwareInformation|null
     */
    public function getPlanningfeatures()
    {
        return $this->Planningfeatures;
    }
    /**
     * Set Planningfeatures value
     * @param \StructType\VehicleSoftwareInformation $planningfeatures
     * @return \StructType\VehicleObcInfo
     */
    public function setPlanningfeatures(\StructType\VehicleSoftwareInformation $planningfeatures = null)
    {
        $this->Planningfeatures = $planningfeatures;
        return $this;
    }
    /**
     * Get ResponseImage value
     * @return string|null
     */
    public function getResponseImage()
    {
        return $this->ResponseImage;
    }
    /**
     * Set ResponseImage value
     * @param string $responseImage
     * @return \StructType\VehicleObcInfo
     */
    public function setResponseImage($responseImage = null)
    {
        // validation for constraint: string
        if (!is_null($responseImage) && !is_string($responseImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseImage, true), gettype($responseImage)), __LINE__);
        }
        $this->ResponseImage = $responseImage;
        return $this;
    }
    /**
     * Get ModemChannelID value
     * @return string|null
     */
    public function getModemChannelID()
    {
        return $this->ModemChannelID;
    }
    /**
     * Set ModemChannelID value
     * @param string $modemChannelID
     * @return \StructType\VehicleObcInfo
     */
    public function setModemChannelID($modemChannelID = null)
    {
        // validation for constraint: string
        if (!is_null($modemChannelID) && !is_string($modemChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modemChannelID, true), gettype($modemChannelID)), __LINE__);
        }
        $this->ModemChannelID = $modemChannelID;
        return $this;
    }
}
